#include "stdafx.h"
#include "User_Api.h"
#include "PET_Type.h"

#if defined(WIN32)
#ifdef _M_X64
	#ifdef _DEBUG
		#pragma comment(lib, "../debug/x64/PETx64.lib")
	#else
		#pragma comment(lib, "../release/x64/PETx64.lib")
	#endif
#else 
	#ifdef _DEBUG
		#pragma comment(lib, "../debug/x86/PET.lib")
	#else
		#pragma comment(lib, "../release/x86/PET.lib")
	#endif
#endif
#endif

#define	BOARD_INFO         1
#define	HWM_TEST           2
//#define CPU_Info           3
#define EC_IIC_Word        4
#define EC_IIC_Byte_Write  5
#define EC_IIC_Byte_Read   6
#define EC_IIC_Quick       7
#define EC_IIC_Block      19
#define WDT_TEST           8
#define	GPIO_READ          9
#define	GPIO_WRITE        10
#define	GPIO_SETDIR       22
#define	TEST_GPIO_INPUT   11
#define	TEST_GPIO_INPUT2  12
#define	SMBUS_TEST        13
#define SMBUS_EEPROM_TEST 20
#define SMBUS_SCAN        21
#define	BLC_TEST          14
#define	BEEP_TEST         15
#define	NOTE_TEST         16
#define	EC_IIC_RWC        17
#define	FAN_TEST          18
#define WDT_DISABLE       23
#define LED_ONOFF         24
#define LED_READ          25
#define LAN_BYPASS_CFG    26
#define LAN_BYPASS_WDT_TEST 27
#define LAN_BYPASS_WDT_DISABLE 28
#define BTN_TEST          29
#define	OPTION_MAX        30

int menuOPT(int *opt){
	char input[10];
	printf ("==== Portwell Inc ====\n");
	printf ("Test Menus:\n");
#ifdef BOARD_INFO
	printf("%2d)BOARD_INFO\n", BOARD_INFO);
#endif
#ifdef HWM_TEST
	printf("%2d)HWM_TEST\n", HWM_TEST);
#endif
#ifdef CPU_Info
	printf("%2d)CPU_Info\n", CPU_Info);
#endif
#ifdef EC_IIC_Word
	printf("%2d)EC_IIC_Word\n", EC_IIC_Word);
#endif
#ifdef EC_IIC_Byte_Write
	printf("%2d)EC_IIC_Byte_Write\n", EC_IIC_Byte_Write);
#endif
#ifdef EC_IIC_Byte_Read
	printf("%2d)EC_IIC_Byte_Read\n", EC_IIC_Byte_Read);
#endif
#ifdef EC_IIC_Quick
	printf("%2d)EC_IIC_Quick\n", EC_IIC_Quick);
#endif
#ifdef EC_IIC_Block
	printf("%2d)EC_IIC_Block\n", EC_IIC_Block);
#endif
#ifdef WDT_TEST
	printf("%2d)WDT_TEST\n", WDT_TEST);
#ifdef WDT_DISABLE
	printf("%2d)WDT_DISABLE\n", WDT_DISABLE);
#endif
#endif
#ifdef GPIO_READ
	printf("%2d)GPIO_READ\n", GPIO_READ);
#endif
#ifdef GPIO_WRITE
	printf("%2d)GPIO_WRITE\n",GPIO_WRITE);
#endif
#ifdef GPIO_SETDIR
	printf("%2d)GPIO_SETDIR\n",GPIO_SETDIR);
#endif
#ifdef TEST_GPIO_INPUT
	printf("%2d)TEST_GPIO_INPUT\n", TEST_GPIO_INPUT);
#endif
#ifdef TEST_GPIO_INPUT2
	printf("%2d)TEST_GPIO_INPUT2\n", TEST_GPIO_INPUT2);
#endif
#ifdef SMBUS_TEST
	printf("%2d)SMBUS_TEST\n", SMBUS_TEST);
#endif
#ifdef SMBUS_SCAN
	printf("%2d)SMBUS_SCAN\n", SMBUS_SCAN);
#endif
#ifdef SMBUS_EEPROM_TEST
	printf("%2d)SMBUS_EEPROM_TEST\n", SMBUS_EEPROM_TEST);
#endif
#ifdef ECSMBUS_TEST
	printf("%2d)ECSMBUS_TEST\n", ECSMBUS_TEST);
#endif
#ifdef BLC_TEST
	printf("%2d)BLC_TEST\n", BLC_TEST);
#endif
#ifdef BEEP_TEST
	printf("%2d)BEEP_TEST\n", BEEP_TEST);
#endif
#ifdef NOTE_TEST
	printf("%2d)NOTE_TEST\n", NOTE_TEST);
#endif
#ifdef IIC_TEST
	printf("%2d)IIC_TEST\n", IIC_TEST);
#endif
#ifdef EC_IIC_RWC
	printf("%2d)EC_IIC_RWC\n", EC_IIC_RWC);
#endif
#ifdef FAN_TEST
	printf("%2d)FAN_TEST\n", FAN_TEST);
#endif
#ifdef LED_ONOFF
	printf("%2d)LED_ONOFF\n", LED_ONOFF);
#endif
#ifdef LED_READ
	printf("%2d)LED_READ\n", LED_READ);
#endif
#ifdef LAN_BYPASS_CFG
	printf("%2d)LAN_BYPASS_CFG\n", LAN_BYPASS_CFG);
#endif
#ifdef LAN_BYPASS_WDT_TEST
	printf("%2d)LAN_BYPASS_WDT_TEST\n", LAN_BYPASS_WDT_TEST);
#endif
#ifdef LAN_BYPASS_WDT_DISABLE
	printf("%2d)LAN_BYPASS_WDT_DISABLE\n", LAN_BYPASS_WDT_DISABLE);
#endif
#ifdef BTN_TEST
	printf("%2d)BTN_TEST\n", BTN_TEST);
#endif
	printf("Please Enter Test option\n");
	fgets(input, 10, stdin);
	*opt = atoi(input);
	if(*opt == 0 && input[0] != '0')
		return 1;
	else if(*opt < 0 || *opt >= OPTION_MAX)
		return 1;
	else
		return NOERROR;
}

static const char errorMsg[][30]={
"NOERROR",//0
"UNKNOWN_ERROR",//1
"DRIVER_NOT_FOUND",//2
"DRIVER_NOT_LOADED",//3
"DRIVER_NOT_LOADED_ON_NETWORK",	//4
"NOSUPPORTED_PLATFORM",//5
"INITIAL_ERROR",//6
"INVALID_PARAMETER",//7
"READ_ERROR",//8
"WRITE_ERROR",//9
"NOT_SUPPORT",//10
"UNAVAILAVLE_SLEEP_TIME",//11
"CANNOT_SET_IO_PERMISSION",//12
"CANNOT_SET_BACK_IO_PERMISSION",//13
"NOT_READY",//14
"UNAVAILABLE_SOUND",//15
"DMI_GETMISS",//16
"DEVICE_NOT_FOUND",//17
};
#ifdef EC_IIC_RWC
int testeciic(int rwc, char* addr, int base){
	unsigned char slave_addr = 0;
	unsigned char value = 0;
	unsigned char chkval = 0;
	int i, ret, chk = 0;
    FILE *fp;

	if(addr != NULL)	  
		slave_addr = (unsigned char)strtoul(addr, NULL, 16);
	else
		slave_addr =0xa0;
	printf("slave_addr=%#x\n", slave_addr);

	if(rwc == 1){
		fp=fopen("read.bin","w");
		if(fp==NULL){
			printf("open file error!!\n");
			return 1;
		} 
		for(i=0x00;i<=0xff;i++){
//		(unsigned char slave_addr,unsigned int offset,unsigned char *value,int length);
			ret = PET_EC_IIC_Byte_Addr_Read(slave_addr, i, &value, 1);
			if(ret != 0){
				if (ret == NOT_SUPPORT)
					printf ("The EC I2C function no support.\n");
				else
					printf("\nread %#x val=%#x failed\n", i, value);
				break;
			}
			fwrite(&value,1, sizeof(value), fp);
		}
		fclose(fp);
	}else if(rwc == 3){
		fp=fopen("write.bin","r");
		if(fp==NULL){
			printf("open file error!!\n");
			return 1;
		} 
		for(i=0x00;i<=0xff;i++){
//		(unsigned char slave_addr,unsigned int offset,unsigned char *value,int length);
			ret = PET_EC_IIC_Byte_Addr_Read(slave_addr, i, &value, 1);
			if(ret != 0){
				if (ret == NOT_SUPPORT)
					printf ("The EC I2C function no support.\n");
				else
					printf("\nread %#x val=%#x failed\n", i, value);
				break;
			}
			fread(&chkval,1, sizeof(chkval), fp);
			if(chkval != value){
				printf("\ncheck %#x val=%#x chkval=%#x failed\n", i, value, chkval);
				chk++;
			}
		}
		if (chk == 0)
			printf("Check eeprom %#x PASS!\n", slave_addr);
		fclose(fp);
	}else if(rwc == 2){
		fp=fopen("write.bin","w");
		if(fp==NULL){
			printf("open file error!!\n");
			return 1;
		} 
		for(i=0x00;i<=0xff;i++){
			value = (i+base)%0x100;
			ret = PET_EC_IIC_Byte_Addr_Write(slave_addr, i, &value, 1);
			if(ret != 0){
				if (ret == NOT_SUPPORT)
					printf ("The EC I2C function no support.\n");
				else
				printf("\nwrite %#x val=%#x failed\n", i, value);
				break;
			}
			fwrite(&value,1, sizeof(value), fp);
//			printf("write %#x val=%#x\n", i, value);
		}
		if (i == 0x100)
			printf("Write eeprom %#x PASS!\n", slave_addr);
		else
			chk = 1;
		fclose(fp);
	}
	return chk;
}
#endif
#ifdef LAN_BYPASS_CFG
static const char bypass_status[][24]={
"bypass control onoff",
"power on bypass mode", //#define PET_LANBYPASS_POWERON	1
"power off bypass mode", //#define PET_LANBYPASS_POWEROFF	2
"next boot bypass mode", //#define PET_LANBYPASS_NEXTBOOT	3
"wdt trigger bypass mode", //#define PET_LANBYPASS_WDT_RUNNING  4
"wdt timeout bypass mode", //#define PET_LANBYPASS_WDT_TIMEOUT  5
"wdt timeout", //#define PET_LANBYPASS_WDT_TIMER  6
};
static const char bypass_mode[][7]={
	"normal",//#define PET_LANBYPASS_NORMAL_MODE 0
	"open", //#define PET_LANBYPASS_OPEN_MODE   1
	"normal",
	"bypass" //#define PET_LANBYPASS_BYPASS_MODE 3
};

void printOCPUsage(char* appname){
	int i;
	printf("Usage: %s %d <set|get> <lan port set index> <config index> [<config option>]\n", appname, LAN_BYPASS_CFG);
	printf("\t<set|get>: 0=set 1=get\n");
	printf("\t<lan port set index>: set index of lan port\n");
	printf("\t<config index>: \n");
	for(i=1;i<PET_LANBYPASS_MODE_MAX;i++){
		printf("\t\t%d: %s\n",i, bypass_status[i]);
	}
	printf("\t<config option>: bypass mode or timeout.\n\t\t0=Normal Mode 1=Open Mode 3=Bypass Mode.\n\t\ttimer:0~15360\n");
	printf("\t<timeout>: timeout second(3~255). -1:not change. set WDT timeout\n");
}

#endif
#ifdef SMBUS_TEST
int smbus_test(int argc, char* argv[]) {
	int error_code, rw;
	unsigned char slaveAddress, offset, smbus_value=0;
	if (argc < 3) {
		printf("Please select smbus read/write:(read=%d/write=%d)\n", SM_READ, SM_WRITE);
		if (scanf("%d", &rw) != 1) {
			printf("Invalid Input!");
			return INVALID_PARAMETER;
		}
	}
	else
		rw = atoi(argv[2]);
	if (rw != SM_READ && rw != SM_WRITE) {
		printf("Invalid Input!");
		return INVALID_PARAMETER;
	}
	if (argc < 4) {
		printf("Please input target smbus device address(8 bits):\n");
		if (scanf("%hhx", &slaveAddress) != 1) {
			printf("Invalid Input!");
			return INVALID_PARAMETER;
		}
	}
	else
		slaveAddress = (unsigned char)strtoul(argv[3], NULL, 16);
	if (slaveAddress % 2 == 1) {
		printf("Invalid Input!");
		return INVALID_PARAMETER;
	}
	if (argc < 5) {
		printf("Please input target smbus offset:\n");
		if (scanf("%hhx", &offset) != 1) {
			printf("Invalid Input!");
			return INVALID_PARAMETER;
		}
	}
	else
		offset = (unsigned char)strtoul(argv[4], NULL, 16);
	if (argc < 6) {
		if (rw == SM_WRITE) {
			printf("Please input target smbus data:\n");
			if (scanf("%hhx", &smbus_value) != 1) {
				printf("Invalid Input!");
				return INVALID_PARAMETER;
			}
		}
	}else if(argc == 6 && rw == SM_WRITE)
		smbus_value = (unsigned char)strtoul(argv[5], NULL, 16);
	else{
		printf("Invalid Input!");
		return INVALID_PARAMETER;
	}

	error_code = PET_SMBus_ByteData (rw, slaveAddress, offset, &smbus_value);
	if(error_code==0)
		printf("%s smbus device %#x, offset %#x, data %#x PASS\n", rw==SM_READ?"Read":"Write",slaveAddress, offset, smbus_value);
	else if (error_code == NOT_SUPPORT)
		printf ("The SMBus function no support.\n");
	else
		printf("%s smbus device %#x, offset %#x, data %#x Error(%#x)\n", rw == SM_READ ? "Read" : "Write", slaveAddress, offset, smbus_value, error_code);
	return error_code;
}
#endif

int main(int argc, char* argv[])
{
	int i, j, opt, gpio_set, gpio_pin;
	int ret, error_code = 1;
    char temp [50];
	unsigned char gpio_value, gpio_direction;
    double cputemp, systemp, voltage, current;
    int fantype, fan_value, fan_ratio, ecypte, fanstat, fanstart, fanfull, fantol;
	int fan_temp[4];
	int fd_pwm[4];

    int wdt_type = SECOND_MODE;
	unsigned char wdt_timeout = 10;
    unsigned char wdt_min, wdt_max;

	unsigned char slave_addr = 0xA0; //SPD
	unsigned char offset = 0x00;

	//for ec iic function
	unsigned char slaveAddress=0xAE;
	int addrH, addrL, address=0x00;
	unsigned char value[32];
	int bypasscfgs[6];
	int length=0;		
	int iEnd=0;	
	unsigned char quick_value;
	unsigned int plat_ver;
#ifdef HWM_TEST
#define MAX_VOL_IDX 14
int vol_arr[MAX_VOL_IDX]={
    VOL_VCORE, 
	VOL_VCCDDR,
	VOL_3P3V,
	VOL_VCC,
	VOL_12V,
	VOL_12V2,
	VOL_24V,
	VOL_VBAT,
	VOL_VTT,
	VOL_CCM,
	VOL_3VSB,
	VOL_AVSB,
	PSU_VIN,
	PSU_VOUT
};
char vol_str[MAX_VOL_IDX][20]={
    "CPU Vcore",
	"DDR Vcc",
	"EC 3.3V",
	"EC 5V",
	"EC 12V",
	"EC 12V2",
	"EC 24V",
	"EC Battery V",
	"EC Vtt",
	"EC Vccm",
	"EC 3Vsb",
	"EC AVSB",
	"PSU Vin",
	"PSU Vout",
};
#endif

#ifdef __linux__
	int sta;

	sta=seteuid(0);
	if(sta < 0)
    {
		printf ("error: seteuid failed.\n");
		printf ("Warning! PET need to access /dev/mem and ioport\n");
		printf("Please use \"sudo chown root:root TESTAP && sudo chmod +s TESTAP\" to allow access\n");
		return 1;
    }
//	printf ("effective uid: %d\n", geteuid());
#endif	
	
	if(argc >= 2){
		opt = atoi(argv[1]);
		if((opt > 0 && opt < OPTION_MAX) || (opt == 0 && argv[1][0]=='0'))
			error_code = NOERROR;
	}else
		error_code = menuOPT(&opt);
	if(error_code != NOERROR){
		printf("Please input correct option!");
		return 1;
	}
	error_code = PET_API_Init();
	if (error_code != NOERROR)
	{
		if (error_code == NOSUPPORTED_PLATFORM)
			printf ("The PET API Library not support the board.\n");
		else
			printf("API init fail: %s(%d)\n", errorMsg[error_code], error_code);
		PET_API_Uninit ();
		return 1;
	}

	
switch(opt){
#ifdef BOARD_INFO
case BOARD_INFO:
{
	ret = PET_Board_GetPlatformName (temp); 
	if (ret == NOERROR)
		printf ("Board name: %s\n", temp);
	else if (ret == NOT_SUPPORT){
		printf ("The Board name function no support.\n");
		error_code = ret;
	}else{
		error_code = ret;
		printf ("Get board name error: %s(%d)\n", errorMsg[error_code], error_code);
	}

	ret = PET_Board_GetBIOSVersion (temp);
	if (ret == NOERROR)
		printf ("PET Board BIOS Version: %s\n", temp);
	else if (ret == NOT_SUPPORT){
		error_code = ret;
		printf ("The Board BIOS function no support.\n");
	}
	else{
		error_code = ret;
		printf ("Get BIOS version error: %s(%d)\n", errorMsg[error_code], error_code);
	}

	ret = PET_API_GetVersion (temp);
	if (ret == NOERROR)
		printf ("PET API Version: %s\n", temp);
	else if (ret == NOT_SUPPORT){
		error_code = ret;
		printf ("The PET API function no support.\n");
	}
	else{
		error_code = ret;
		printf ("Get API version error: %s(%d)\n", errorMsg[error_code], error_code);
	}

	ret = PET_Board_GetECVersion(temp);
	if (ret == NOERROR)
		printf ("PET EC Version: %s\n", temp);
	else if (ret != NOT_SUPPORT){
		error_code = ret;
		printf ("Get EC version error: %s(%d)\n", errorMsg[error_code], error_code);
	}
#ifdef PETAPI_DEBUG
	else
		printf ("The PET EC function no support.\n");
#endif

	ret = PET_Board_GetECInfo(SEC_EC_VER, temp);
	if (ret == NOERROR)
		printf ("PET EC2 Version: %s\n", temp);
	else if (ret != NOT_SUPPORT){
		error_code = ret;
		printf ("Get EC2 version error: %s(%d)\n", errorMsg[error_code], error_code);
	}
#ifdef PETAPI_DEBUG
	else
		printf ("The PET EC2 function no support.\n");
#endif
	ret = PET_Get_Platform_Version(&plat_ver);
	if (ret == NOERROR)
		printf ("PET_Get_Platform_Version: %#x\n", plat_ver);
	else if (ret != NOT_SUPPORT){
		error_code = ret;
		printf ("Get Platform Version error: %s(%d)\n", errorMsg[error_code], error_code);
	}
#ifdef PETAPI_DEBUG
	else
		printf ("The PET Platform Version function no support.\n");
#endif	

	ret = PET_Board_GetSerialNumber(temp);
	if (ret == NOERROR)
		printf ("Serial Number: %s\n", temp);
	else if (ret != NOT_SUPPORT){
		error_code = ret;
		printf ("Get Serial Number error: %s(%d)\n", errorMsg[error_code], error_code);
	}
#ifdef PETAPI_DEBUG
	else
		printf ("The PET EC function no support.\n");
#endif

#ifdef PETAPI_DEBUG
	ret = PET_API_SetIOSleepTime (10); // 10u second
	if (ret == NOERROR)
		printf ("Set I/O sleep time is successful\n");
	else if (ret == NOT_SUPPORT){
		error_code = ret;
		printf ("PET_API_SetIOSleepTime function no support.\n");
	}
	else{
		error_code = ret;
		printf ("Set I/O sleep time error: %s(%d)\n", errorMsg[error_code], error_code);
	}
#endif
}
break;
#endif
#ifdef HWM_TEST
case HWM_TEST:
{
	printf ("\n==== Hardware Monitor ====\n");
	ret = PET_HWM_CPUTemperature (0, &cputemp);
	if (ret == NOERROR)
		printf ("CPU temperature value is %3.2f\n", cputemp);
	else if (ret == NOT_SUPPORT)
		printf ("The CPU temperature function no support.\n");
	else{
		error_code = ret;
		printf ("Get CPU temperature error: %s(%d)\n", errorMsg[error_code], error_code);
	}
//	ret = PET_HWM_SysTemperature (&systemp);
	ret = PET_HWM_Temperature (TSENSOR_SYS1, &systemp);
	if (ret == NOERROR)
		printf ("System temperature value is %3.2f\n", systemp);
	else if (ret != NOT_SUPPORT){
		error_code = ret;
		printf ("Get System temperature error: %s(%d)\n", errorMsg[error_code], error_code);
	}
#ifdef PETAPI_DEBUG
	else
		printf ("The System temperature function no support.\n");
#endif	
	ret = PET_HWM_Temperature (TSENSOR_SYS2, &systemp);
	if (ret == NOERROR)
		printf ("System temperature 2 value is %3.2f\n", systemp);
	else if (ret != NOT_SUPPORT){
		error_code = ret;
		printf ("Get System temperature 2 error: %s(%d)\n", errorMsg[error_code], error_code);
	}
#ifdef PETAPI_DEBUG
	else
		printf ("The System temperature 2 function no support.\n");
#endif	
	ret = PET_HWM_Temperature (TSENSOR_SYS3, &systemp);
	if (ret == NOERROR)
		printf ("System temperature 3 value is %3.2f\n", systemp);
	else if (ret != NOT_SUPPORT){
		error_code = ret;
		printf ("Get System temperature 3 error: %s(%d)\n", errorMsg[error_code], error_code);
	}
#ifdef PETAPI_DEBUG
	else
		printf ("The System temperature 3 function no support.\n");
#endif	
	ret = PET_HWM_Temperature (TSENSOR_SYS4, &systemp);
	if (ret == NOERROR)
		printf ("System temperature 4 value is %3.2f\n", systemp);
	else if (ret != NOT_SUPPORT){
		error_code = ret;
		printf ("Get System temperature 4 error: %s(%d)\n", errorMsg[error_code], error_code);
	}
#ifdef PETAPI_DEBUG
	else
		printf ("System temperature 4 value is %3.2f\n", systemp);
#endif	
	ret = PET_HWM_Temperature (TSENSOR_PSU1, &systemp);
	if (ret == NOERROR)
		printf ("PSU 1 temperature value is %3.2f\n", systemp);
	else if (ret != NOT_SUPPORT){
		error_code = ret;
		printf ("Get PSU 1 temperature error: %s(%d)\n", errorMsg[error_code], error_code);
	}
#ifdef PETAPI_DEBUG
	else
		printf ("The PSU 1 temperature function no support.\n");
#endif	
	ret = PET_HWM_Temperature (TSENSOR_PSU1, &systemp);
	if (ret == NOERROR)
		printf ("PSU 2 temperature value is %3.2f\n", systemp);
	else if (ret != NOT_SUPPORT){
		error_code = ret;
		printf ("Get PSU 2 temperature error: %s(%d)\n", errorMsg[error_code], error_code);
	}
#ifdef PETAPI_DEBUG
	else
		printf ("The PSU 2 temperature function no support.\n");
#endif	
	ret = PET_HWM_Temperature (TSENSOR_DDR1, &systemp);
	if (ret == NOERROR)
		printf ("DDR temperature value is %3.2f\n", systemp);
	else if (ret != NOT_SUPPORT){
		error_code = ret;
		printf ("Get DDR temperature error: %s(%d)\n", errorMsg[error_code], error_code);
	}
#ifdef PETAPI_DEBUG
	else
		printf ("The DDR temperature function no support.\n");
#endif	
	for(i=0;i<MAX_VOL_IDX;i++){
		ret = PET_HWM_Voltage (vol_arr[i], &voltage);
		if (ret == NOERROR)
			printf ("%s value is %3.3f (V)\n", vol_str[i], voltage);
		else if (ret != NOT_SUPPORT){
			error_code = ret;
			printf ("Get %s value error, error number %d\n",vol_str[i], error_code);
		}
#ifdef PETAPI_DEBUG
		else
			printf ("The %s function no support.\n", vol_str[i]);
#endif		
	}

	ret = PET_HWM_Current (CUR_PSU1, &current);
	if (ret == NOERROR)
		printf ("PSU1 Current: %3.3f (A)\n", current);
	else if (ret != NOT_SUPPORT){
			error_code = ret;
			printf ("Get Current error: %s(%d)\n", errorMsg[error_code], error_code);
		}
#ifdef PETAPI_DEBUG
		else
			printf ("Current function no support.\n");
#endif

	ret = PET_HWM_Current (CUR_PSU2, &current);
	if (ret == NOERROR)
		printf ("PSU2 Current: %3.3f (A)\n", current);
	else if (ret != NOT_SUPPORT){
			error_code = ret;
			printf ("Get Current error: %s(%d)\n", errorMsg[error_code], error_code);
		}
#ifdef PETAPI_DEBUG
		else
			printf ("Current function no support.\n");
#endif

	ret = PET_HWM_GetFanSpeed (CPUFAN, &fan_value);
	if (ret == NOERROR)
		printf ("CPU fan speed: %d\n", fan_value);
	else if (ret == NOT_SUPPORT)
		printf ("CPU fan speed function no support.\n");
	else{
		error_code = ret;
		printf ("Get CPU fan speed error: %s(%d)\n", errorMsg[error_code], error_code);
	}

	ret = PET_HWM_GetFanSpeed (SYSFAN, &fan_value);
	if (ret == NOERROR)
		printf ("System fan speed: %d\n", fan_value);
	else if (ret != NOT_SUPPORT){
		error_code = ret;
		printf ("Get System fan speed error: %s(%d)\n", errorMsg[error_code], error_code);
	}
#ifdef PETAPI_DEBUG
	else
		printf ("System fan speed function no support.\n");
#endif

	ret = PET_HWM_GetFanSpeed (SYSFAN2, &fan_value);
	if (ret == NOERROR)
		printf ("System fan2 speed: %d\n", fan_value);
	else if (ret != NOT_SUPPORT){
		error_code = ret;
		printf ("Get System fan2 speed error: %s(%d)\n", errorMsg[error_code], error_code);
	}
#ifdef PETAPI_DEBUG
	else
		printf ("System fan2 speed function no support.\n");
#endif

	ret = PET_HWM_GetFanSpeed (SYSFAN3, &fan_value);
	if (ret == NOERROR)
		printf ("System fan3 speed: %d\n", fan_value);
	else if (ret != NOT_SUPPORT){
		error_code = ret;
		printf ("Get System fan3 speed error: %s(%d)\n", errorMsg[error_code], error_code);
	}
#ifdef PETAPI_DEBUG
	else
		printf ("System fan3 speed function no support.\n");
#endif

	ret = PET_HWM_GetFanSpeed (SYSFAN4, &fan_value);
	if (ret == NOERROR)
		printf ("System fan4 speed: %d\n", fan_value);
	else if (ret != NOT_SUPPORT){
		error_code = ret;
		printf ("Get System fan4 speed error: %s(%d)\n", errorMsg[error_code], error_code);
	}
#ifdef PETAPI_DEBUG
	else
		printf ("System fan4 speed function no support.\n");
#endif

	ret = PET_HWM_GetFanSpeed (SYSFAN5, &fan_value);
	if (ret == NOERROR)
		printf ("System fan5 speed: %d\n", fan_value);
	else if (ret != NOT_SUPPORT){
		error_code = ret;
		printf ("Get System fan5 speed error: %s(%d)\n", errorMsg[error_code], error_code);
	}
#ifdef PETAPI_DEBUG
	else
		printf ("System fan5 speed function no support.\n");
#endif

    ret = PET_HWM_GetFanSpeed (AUXFAN, &fan_value);
    if (ret == NOERROR)
		printf ("AUX fan speed: %d\n", fan_value);
	else if (ret != NOT_SUPPORT){
		error_code = ret;
		printf ("Get AUX fan speed error: %s(%d)\n", errorMsg[error_code], error_code);
	}
#ifdef PETAPI_DEBUG
	else
		printf ("AUX fan speed function no support.\n");
#endif

    ret = PET_HWM_GetFanSpeed (PSU_FAN1, &fan_value);
    if (ret == NOERROR)
		printf ("PSU1 fan speed: %d\n", fan_value);
	else if (ret != NOT_SUPPORT){
		error_code = ret;
		printf ("Get PSU1 fan speed error: %s(%d)\n", errorMsg[error_code], error_code);
	}
#ifdef PETAPI_DEBUG
	else
		printf ("PSU1 fan speed function no support.\n");
#endif

    ret = PET_HWM_GetFanSpeed (PSU_FAN2, &fan_value);
    if (ret == NOERROR)
		printf ("PSU2 fan speed: %d\n", fan_value);
	else if (ret != NOT_SUPPORT){
		error_code = ret;
		printf ("Get PSU2 fan speed error: %s(%d)\n", errorMsg[error_code], error_code);
	}
#ifdef PETAPI_DEBUG
	else
		printf ("PSU2 fan speed function no support.\n");
#endif
}
break;
#endif
#ifdef FAN_TEST
case FAN_TEST:
{
	i=999;
	if(PET_Board_GetECVersion(temp)== NOT_SUPPORT)
		ecypte=0;
	else
		ecypte=1;

	do{
		printf("1)CPU Fan\n");
		printf("2)System Fan\n");
		printf("3)System Fan2\n");
		printf("4)AUX Fan\n");
		printf("Please input read data offset:\n");
	}while(scanf("%d", &j)!=1);
	switch(j){
		case 1:
		fantype=CPUFAN;
		sprintf(temp, "CPU Fan");
		break;
		case 2:
		fantype=SYSFAN;
		sprintf(temp, "SYS Fan");
		break;
		case 3:
		fantype=SYSFAN2;
		sprintf(temp, "SYS Fan2");
		break;
		case 4:
		fantype=AUXFAN;
		sprintf(temp, "AUX Fan");
		break;
		default:
			return -1;
	}
	do{
		printf("\n1)Set Fan Speed\n");
		printf("2)Get Fan Speed\n");
		printf("3)Enable Smart Fan\n");
		printf("4)Set Smart Fan Config\n");
		printf("5)Get Smart Fan Config\n");
		printf("6)End Test\n");
		if(scanf("%d", &i)!=1){
			printf("Incorrect input\n");
			continue;
		}
		switch(i){
		case 1:
			printf("Please input Fan speed ratio(0-100):\n");
			if(scanf("%d", &fan_ratio)!=1){
				printf("Incorrect input\n");
				break;
			}
			if(fan_ratio < 0 || fan_ratio >100){
				printf("Incorrect input\n");
				break;
			}
			error_code = PET_HWM_SetFanSpeed (fantype, fan_ratio);
			if (error_code == NOERROR)
				printf ("Set %s fan speed ratio: %d%%\n", temp, fan_ratio);
			else if (error_code == NOT_SUPPORT)
				printf ("Set %s speed function no support.\n", temp);
			else
				printf ("Set %s speed error: %s(%d)\n", temp, errorMsg[error_code], error_code);
		break;
		case 2:
			error_code = PET_HWM_GetFanSpeed (fantype, &fan_value);
			if (error_code == NOERROR)
				printf ("%s speed: %d\n", temp, fan_value);
			else if (error_code == NOT_SUPPORT)
				printf ("%s speed function no support.\n", temp);
			else
				printf ("Get %s speed error: %s(%d)\n", temp, errorMsg[error_code], error_code);
		break;
		case 3:
			error_code = PET_HWM_Smartfan_Enable(fantype);
			if (error_code == NOERROR)
				printf ("smart fan ok!\n");
			else if (error_code == NOT_SUPPORT)
				printf ("Function no support.\n");
			else
				printf ("Enable smart fan error: %s(%d)\n", errorMsg[error_code], error_code);
		break;
		case 4:
		if(ecypte == 0){
			for(j=0;j<4;j++){
				do{
					printf("Please input Temperature:\n");
				}while(scanf("%d", fan_temp+j)!=1);
				if(fan_temp[j] < 0 || fan_temp[j] >100){
					printf("Incorrect input\n");
					break;
				}
				do{
					printf("Please input FD/PWM1(0-100):\n");
				}while(scanf("%d", fd_pwm+j)!=1);
				if(fd_pwm[j] < 0 || fd_pwm[j] >100){
					printf("Incorrect input\n");
					break;
				}
			}
			if(j <4)break;
			error_code = PET_HWM_SetSmartfan(fantype, PET_FANMODE_SMART_IV, fan_temp, fd_pwm, -1);
			if (error_code == NOERROR){
			error_code = PET_HWM_GetSmartfan(fantype, &fanstat, fan_temp, fd_pwm, &fantol);
				if (error_code == NOERROR){
					printf("Temperature 1=%d FD/RPM1=%d%%\n", fan_temp[0], fd_pwm[0]);
					printf("Temperature 2=%d FD/RPM2=%d%%\n", fan_temp[1], fd_pwm[1]);
					printf("Temperature 3=%d FD/RPM3=%d%%\n", fan_temp[2], fd_pwm[2]);
					printf("Temperature 4=%d FD/RPM4=%d%%\n", fan_temp[3], fd_pwm[3]);
				}else
					printf ("%s get smart function error: %s(%d)\n", temp, errorMsg[error_code], error_code);
			}else if (error_code == NOT_SUPPORT)
				printf ("%s smart function no support.\n", temp);
			else if (error_code == NOT_READY)
				printf ("%s smart function not enabled.\n", temp);
			else
				printf ("%s smart function error: %s(%d)\n", temp, errorMsg[error_code], error_code);
		}
		else
		{
			printf("Please input Start Temperature:\n");
			if(scanf("%d", &fanstart)!=1){
				printf("Incorrect input\n");
				break;
			}
			printf("Please input Full Speed Temperature:\n");
			if(scanf("%d", &fanfull)!=1){
				printf("Incorrect input\n");
				break;
			}
			printf("Please input Temperature Tolerance:\n");
			if(scanf("%d", &fantol)!=1){
				printf("Incorrect input\n");
				break;
			}
			fan_temp[0]=fanstart;
			fan_temp[1]=fanfull;
			fd_pwm[0]=30;
			fd_pwm[1]=100;
			error_code = PET_HWM_SetSmartfan(fantype, PET_FANMODE_THERMAL, fan_temp, fd_pwm, fantol);
			if (error_code == NOERROR){
				error_code = PET_HWM_GetSmartfan(fantype, &fanstat, fan_temp, fd_pwm, &fantol);
				if (error_code == NOERROR){
					printf("Smart Fan %s\n", fanstat == PET_FANMODE_THERMAL?"Enabled":"Disabled");
					printf("Start Temperature=%d\n", fan_temp[0]);
					printf("Full Speed Temperature=%d\n", fan_temp[1]);
					printf("Tolerance=%d\n", fantol);
				}else
					printf ("%s get smart function error: %s(%d)\n", temp, errorMsg[error_code], error_code);
			}else if (error_code == NOT_SUPPORT)
				printf ("%s smart function no support.\n", temp);
			else if (error_code == NOT_READY)
				printf ("%s smart function not enabled.\n", temp);
			else
				printf ("%s smart function error: %s(%d)\n", temp, errorMsg[error_code], error_code);
		}
		break;
		case 5:
			error_code = PET_HWM_GetSmartfan(fantype, &fanstat, fan_temp, fd_pwm, &fantol);
			if (error_code == NOERROR){
				if(fanstat == PET_FANMODE_SMART_IV){
				printf("Temperature 1=%d FD/RPM1=%d%%\n", fan_temp[0], fd_pwm[0]);
				printf("Temperature 2=%d FD/RPM2=%d%%\n", fan_temp[1], fd_pwm[1]);
				printf("Temperature 3=%d FD/RPM3=%d%%\n", fan_temp[2], fd_pwm[2]);
				printf("Temperature 4=%d FD/RPM4=%d%%\n", fan_temp[3], fd_pwm[3]);
				}else if(fanstat == PET_FANMODE_THERMAL){
					printf("Smart Fan Enabled\n");
					printf("Start Temperature=%d\n", fan_temp[0]);
					printf("Full Speed Temperature=%d\n", fan_temp[1]);
					printf("Tolerance=%d\n", fantol);
				}else
					printf ("%s smart fan not enabled.\n", temp);
			}else if (error_code == NOT_SUPPORT)
				printf ("%s smart function no support.\n", temp);
			else if (error_code == NOT_READY)
				printf ("%s smart function not enabled.\n", temp);
			else
				printf ("%s smart function error: %s(%d)\n", temp, errorMsg[error_code], error_code);
		break;
		default:
			i=-1;
		}
	}while(i>0);
}
break;
#endif
#ifdef CPU_Info
case CPU_Info:
	printf ("\n==== Cpu Information ====\n");
	CpuInfo cpu;
	ret = PET_New_CPU_Obj(&cpu);
	if (ret == NOT_SUPPORT)
		printf ("Function no support.\n");
	//static
	printf("Vendor:%s\n",cpu.vendorName);
	printf("Family:%X\n",cpu.familyId);
	printf("Model:%X\n",cpu.modeId);
	printf("Stepping:%X\n",cpu.steppingId);
	printf("Type:%X\n",cpu.typeId);
	printf("TjMax:%d\n",cpu.tjMax);	
	//printf("MaxFrequency:%dMHz\n",cpu.maxFrequency);
#ifdef PETAPI_DEBUG
	printf("-----------------Cache Size Info--------------------\n");
	printf("%s\n",cpu.CacheL1);
	printf("%s\n",cpu.CacheL2);
	printf("%s\n",cpu.CacheL3);

	printf("-----------------Cache TLB Info--------------------\n");	
	for(i=0;i<cpu.cacheTlbInfoLength;i++)
	{
		printf("%d:",(i+1));
		printf("%s\n",cpu.cacheTlbInfo[i]);
	}

	printf("-----------------Cpu Feature--------------------\n");
	for(i=0;i<cpu.featuresLength;i++)
	{
		printf("%d:",(i+1));
		printf("%s\n",cpu.features[i]);		
	}
#endif
	printf("-------------------------------------\n");
	printf("Cpu Temperature:%d\n",cpu.getCpuTemperature());
	printf("CurrentFrequency:%d\n",cpu.getCurrentFrequency());
	printf("Voltage:%f\n",cpu.getVoltage());
	printf("-------------------------------------\n");
break;
#endif
#ifdef EC_IIC_Word
case EC_IIC_Word:
	printf ("\n====EC IIC Test====\n");
	printf("-------------------Word Address--------------------\n");
	printf("Please input target i2c device address(8 bits):\n");
	if(scanf("%hhx", &slaveAddress)!=1){
		printf("Error!Invalid Input!\n");
		break;
	}
	printf("-----------------------Write-----------------------\n");
	address=0x00;
	length=8;
	iEnd=512/length;

	for(i=0;i<length;i++)
		value[i]=(unsigned char)i;		

	for(i=0;i<iEnd;i++)
	{
		addrL=(address&0xff00)>>8;
		addrH=address&0xff;
		error_code=PET_EC_IIC_Word_Addr_Write(slaveAddress,(addrL<<8)+addrH,value,length);
		if(error_code==0)
		{
			printf("Write:");
			for(j=0;j<length;j++)
			{				
				printf("%X,",value[j]);
				value[j]+= (unsigned char)length;
			}
			printf("to %X\n",address);
			address+=length;
		}else
		{
			if (error_code == NOT_SUPPORT)
				printf ("The EC I2C function no support.\n");
			else
				printf("Write Error\n");
			break;
		}

	}
	
	printf("-------------------Word Address--------------------\n");
	printf("-----------------------Read-----------------------\n");
	length=8;	
	address=0x00;
	for(i=0;i<iEnd;i++)
	{				
		addrL=(address&0xff00)>>8;
		addrH=address&0xff;
		error_code=PET_EC_IIC_Word_Addr_Read(slaveAddress,(addrL<<8)+addrH,value,length);
		if(error_code==0)
		{
			printf("Read:");
			for(j=0;j<length;j++)
			{
				printf("%X,",value[j]);				
			}
			printf("from %X\n",address);
			address+=length;
		}else
		{
			if (error_code == NOT_SUPPORT)
				printf ("The EC I2C function no support.\n");
			else
				printf("Read Error\n");
			break;
		}	
	}	
	printf("---------------------------------------------------\n");
break;
#endif
#ifdef EC_IIC_Byte_Write
case EC_IIC_Byte_Write:
	printf ("\n====EC IIC Test====\n");
	
	printf("-------------------Byte Address--------------------\n");
	printf("-----------------------Write-----------------------\n");
	do{
		printf("Please input target i2c device address(8 bits):\n");
	}while(scanf("%hhx", &slaveAddress)!=1);
	do{
		printf("Please input write data offset:\n");
	}while(scanf("%x", &address)!=1);
	do{
		printf("Please input write data value:\n");
	}while(scanf("%hhx", &value)!=1);
	error_code=PET_EC_IIC_Byte_Addr_Write(slaveAddress,address,value,1);
	if(error_code==0)
		printf("I2C device %#x, offset %#x, write data %#x PASS\n", slaveAddress, address, value[0]);
	else if (error_code == NOT_SUPPORT)
		printf ("The EC I2C function no support.\n");
	else
		printf("I2C device %#x, offset %#x, write data %#x FAIL\n", slaveAddress, address, value[0]);
break;
#endif
#ifdef EC_IIC_Byte_Read
case EC_IIC_Byte_Read:
	printf("-------------------Byte Address--------------------\n");
	printf("-----------------------Read-----------------------\n");
	do{
		printf("Please input target i2c device address(8 bits):\n");
	}while(scanf("%hhx", &slaveAddress)!=1);
	do{
		printf("Please input read data offset:\n");
	}while(scanf("%x", &address)!=1);
		value[0]=0xff;
		error_code=PET_EC_IIC_Byte_Addr_Read(slaveAddress,address,value,1);
		if(error_code==0)
			printf("I2C device %#x, offset %#x, Read data %#x PASS\n", slaveAddress, address, value[0]);
		else if (error_code == NOT_SUPPORT)
			printf ("The EC I2C function no support.\n");
		else
			printf("I2C device %#x, offset %#x, Read data  Error(%#x), val=%#x\n", slaveAddress, address, error_code, value[0]);
break;
#endif
#ifdef EC_IIC_Quick
case EC_IIC_Quick:
	printf ("\n====EC IIC Quick Read/Write Test====\n");
	printf("-------------------Byte Address--------------------\n");
	printf("-----------------------Write-----------------------\n");
	do{
		printf("Please input target i2c device address(8 bits):\n");
	}while(scanf("%hhx", &slaveAddress)!=1);
	do{
		printf("Please input write data offset:\n");
	}while(scanf("%hhx", &quick_value)!=1);

	error_code=PET_EC_IIC_Quick_Write(slaveAddress, (unsigned int)quick_value);
	if(error_code==0)
		printf("I2C device %#x, write data %#x PASS\n", slaveAddress, quick_value);
	else if (error_code == NOT_SUPPORT)
		printf ("The EC I2C function no support.\n");
	else
		printf("I2C device %#x, write data %#x Error\n", slaveAddress, quick_value);
	
	printf("-------------------Byte Address--------------------\n");
	printf("-----------------------Read-----------------------\n");
	do{
		printf("Please input target i2c device address(8 bits):\n");
	}while(scanf("%hhx", &slaveAddress)!=1);
	do{
		printf("Please input read data offset:\n");
	}while(scanf("%x", &address)!=1);
		error_code=PET_EC_IIC_Quick_Read(slaveAddress,address,&quick_value);
		if(error_code==0)
			printf("I2C device %#x, offset %#x, Read data %#x PASS\n", slaveAddress, address, quick_value);
		else if (error_code == NOT_SUPPORT)
			printf ("The EC I2C function no support.\n");
		else
			printf("I2C device %#x, offset %#x, Read data %#x Error\n", slaveAddress, address, quick_value);
	printf("---------------------------------------------------\n");
break;
#endif
#ifdef EC_IIC_Block
case EC_IIC_Block:
	length=8;  //Max page size of AT24C02D is 8 bytes
	iEnd=256;
	printf ("\n====EC IIC Test====\n");
	do{
		printf("Please input target i2c device address(8 bits):\n");
	}while(scanf("%hhx", &slaveAddress)!=1);

	printf("-------------------Block Write--------------------\n");
	for(i=0;i<length;i++)
		value[i]= (unsigned char)i;
	for(address=0;address<iEnd;address+=length){
		error_code=PET_EC_IIC_Byte_Addr_Write(slaveAddress, address, value, length);
		if(error_code==0){
			printf("Write:");
			for(j=0;j<length;j++){				
				printf("%02X,",value[j]);
				value[j]+= (unsigned char)length;
			}
			printf("to %02X\n",address);
		}else{
			if (error_code == NOT_SUPPORT)
				printf ("The EC I2C function no support.\n");
			else
				printf("Write Error\n");
			break;
		}
	}
	
	printf("-----------------------Block Read-----------------------\n");
	for(address=0;address<iEnd;address+=length)
	{
		for(j=0;j<length;j++)value[j]=0;
		error_code=PET_EC_IIC_Byte_Addr_Read(slaveAddress, address, value, length);
		if(error_code==0)
		{
			printf("Read:");
			for(j=0;j<length;j++)
				printf("%02X,",value[j]);				
			printf("from %02X\n",address);
		}else{
			if (error_code == NOT_SUPPORT)
				printf ("The EC I2C function no support.\n");
			else
				printf("Read Error\n");
			break;
		}	
	}	
	printf("---------------------------------------------------\n");
	printf("-----------------------Byte Read-----------------------\n");
	address=0x00;	
	for(address=0;address<iEnd;address++)
	{				
		error_code=PET_EC_IIC_Byte_Addr_Read(slaveAddress,address,value,1);
		if(error_code==0)
		{
			if(address%length==0)printf("Read:");
				printf("%02X,",value[0]);				
			if(address%length==(length-1))printf("from %02X\n",address-length+1);
		}else
		{
			if (error_code == NOT_SUPPORT)
				printf ("The EC I2C function no support.\n");
			else
				printf("Read Error\n");
			break;
		}	
	}	
	printf("---------------------------------------------------\n");
break;
#endif
#ifdef WDT_TEST
case WDT_TEST:
	printf ("\n==== Test WDT Function ====\n");
	error_code = PET_WDT_GetRange (SECOND_MODE, &wdt_min, &wdt_max);
	if (error_code == NOERROR)
    	printf ("The WDT seconde mode range: %d ~ %d (sec)\n", wdt_min, wdt_max);
	else if (error_code == NOT_SUPPORT)
		printf ("The WDT range function no support.\n");
	else
		printf ("Get WDT range error: %s(%d)\n", errorMsg[error_code], error_code);

	// wdt type: 0 is second mode, 1 is minute mode
	error_code = PET_WDT_SetConfig (wdt_type, wdt_timeout);
	if (error_code == NOERROR)
		printf ("WDT setting is successful.\n");
	else if (error_code == NOT_SUPPORT)
		printf ("The WDT setting function no support.\n");
	else
		printf ("WDT setting error, error code %d\n", error_code);

	error_code = PET_WDT_GetConfig (&wdt_type, &wdt_timeout);
	if (error_code == NOERROR)
		printf ("WDT type:%d, timeout:%d\n", wdt_type, wdt_timeout);
	else if (error_code == NOT_SUPPORT)
		printf ("The WDT get config function no support.\n");
	else
		printf ("The WDT get config error, error code %d\n", error_code);

    error_code = PET_WDT_Trigger ();
	if (error_code == NOERROR)
		printf ("WDT Trigger NOW !!\n");
	else if (error_code == NOT_SUPPORT)
		printf ("The WDT trigger function no support.\n");
	else
		printf ("The WDT trigger error, error code %d\n", error_code);

	error_code = PET_WDT_Available ();
	if (error_code == NOERROR)
   		printf ("WDT trigger is available.\n");
	else if (error_code == NOT_READY)
	    printf ("The WDT is not Ready.\n");
	else if (error_code == NOT_SUPPORT)
		printf ("The WDT available function no support.\n");
	else
		printf ("The WDT available error, error code %d\n", error_code);

	printf ("If you want to test WDT reset function, Please press Ctrl+C to force wdt_trigger stop before count end.\n");
#ifdef WDT_ACTION
		i=9;
		while(i<10)
		{
			if(i==9){
				error_code = PET_WDT_Trigger();
				i=1;
			}
		    printf ("Reset counter ......%d\n", wdt_timeout - i);
		    Sleep (1000);
			i++;
		}
#else
		for(i=0,j=wdt_timeout;i<2*wdt_timeout;i++,j--)
		{
			if(i%(wdt_timeout-2)==0){
				error_code = PET_WDT_Trigger();
				if(error_code == 0)
		    		printf ("WDT Triggered\n");
				else{
		    		printf ("WDT Trigger error!(%#x)\n", error_code);
					break;
				}
				j=wdt_timeout;
			}
		    printf ("Reset counter ......%d\n", j);
		    Sleep (1000);
		}
case WDT_DISABLE:		
		PET_WDT_Disable();
		printf("WDT is disabled!\n");
#endif
break;
#endif
#ifdef GPIO_SETDIR
case GPIO_SETDIR:
	if (argc == 5) {
		gpio_set = atoi(argv[2]);
		gpio_pin = atoi(argv[3]);
		gpio_direction = (unsigned char)atoi(argv[4]);
	}else {
		printf("Please input target GPIO set:\n");
		if(scanf("%d", &gpio_set)!=1){
			printf("Invalid Input!");
			break;
		}
		printf("Please input target GPIO pin:\n");
		if(scanf("%d", &gpio_pin)!=1){
			printf("Invalid Input!");
			break;
		}
		printf("Please input target GPIO Direction(1:Iuput, 0:Output):\n");
		if(scanf("%hhu", &gpio_direction)!=1){
			printf("Invalid Input!");
			break;
		}
	}
	if(gpio_direction!=0&&gpio_direction!=1){
		printf("Invalid Input!");
		break;
	}
	ret = PET_GPIO_SetPinDirection (gpio_set, gpio_pin, gpio_direction); 
	if (ret != NOERROR) {
		printf(" PET_GPIO_SetPinDirection(%d,%d,%d) failed %d\n", gpio_set, gpio_pin, gpio_direction, ret);
		break;
	}else
		printf("Set gpio group %d pin %d to %s mode\n", gpio_set, gpio_pin, gpio_direction==0?"output":"input");
break;
#endif
#ifdef GPIO_WRITE
case GPIO_WRITE:
	if (argc == 5) {
		printf("GPIO pin write test:\n");
		gpio_set = atoi(argv[2]);
		gpio_pin = atoi(argv[3]);
		gpio_value = (unsigned char)atoi(argv[4]);
		if (gpio_set < 1 || gpio_pin > 9) {
			printf("Error!Incorrect gpio_set!\n");
			break;
		}
		if (gpio_pin < 1 || gpio_pin > 8) {
			printf("Error!Incorrect gpio_pin!\n");
			break;
		}
		if (argv[4][0] != '1' && argv[4][0] != '0') {
			printf("Error!Incorrect gpio_value!\n");
			break;
		}
		printf("Warning: This operation may change gpio direction config!\n");
#ifndef __linux__
		system ("pause");
#else
		printf("Press Enter key to continue...\n");  
		fgetc(stdin); 
#endif
		ret = PET_GPIO_SetPinDirection (gpio_set, gpio_pin, 0); 
		if (ret != NOERROR) {
			printf(" PET_GPIO_SetPinDirection(%d,%d) failed %d\n", gpio_set, gpio_pin, ret);
			break;
		}else
			printf("Set gpio group %d pin %d to output mode\n", gpio_set, gpio_pin);
		printf("write %d to gpio group %d pin %d\n", gpio_value, gpio_set, gpio_pin);
		ret = PET_GPIO_ReadPinDirection(gpio_set, gpio_pin, &gpio_direction);
		if (ret != NOERROR) {
			printf(" PET_GPIO_ReadPinDirection(%d,%d) failed %d\n", gpio_set, gpio_pin, ret);
			break;
		}
		if (gpio_direction != 0) {
			printf(" Error! GPIO(%d,%d) is not OUTPUT mode!\n", gpio_set, gpio_pin);
			break;
		}
		ret = PET_GPIO_WritePin(gpio_set, gpio_pin, gpio_value);
		if (ret != NOERROR)
			printf(" PET_GPIO_WritePin(%d,%d,%d) failed %d\n", gpio_set, gpio_pin, gpio_value, ret);
		else {
			ret = PET_GPIO_Read(gpio_set, &gpio_value);
			printf("GPIO PINS  1 2 3 4 5 6 7 8\n");
			printf("GPIO Data: %d %d %d %d %d %d %d %d\n",
				(gpio_value & 0x01) == 0 ? 0 : 1,
				(gpio_value & 0x02) == 0 ? 0 : 1,
				(gpio_value & 0x04) == 0 ? 0 : 1,
				(gpio_value & 0x08) == 0 ? 0 : 1,
				(gpio_value & 0x10) == 0 ? 0 : 1,
				(gpio_value & 0x20) == 0 ? 0 : 1,
				(gpio_value & 0x40) == 0 ? 0 : 1,
				(gpio_value & 0x80) == 0 ? 0 : 1);
		}
	}
	else {
		if(argc == 3){
			gpio_set = atoi(argv[2]);
			if (gpio_set < 1) {
				printf("Error!Incorrect gpio_set!\n");
				break;
			}
			j=gpio_set;
		}else if(argc > 3){
			printf("GPIO write command:\n");
			printf("TESTAP %d <gpio_set> [<gpio_pin> <gpio_value>]\n", GPIO_WRITE);
			break;
		}else{
			gpio_set=0;
			printf("GPIO group %d write test:\n", gpio_set);
			ret = PET_GPIO_TotalSet(&gpio_set);
			if(ret == 0)
				printf(" Number of GPIO Groups: %d\n", gpio_set);
			else
				printf(" Number of GPIO Groups: Not Support\n");
			j=1;
		}
		for(i=j;i<=gpio_set;i++){
			printf("Write GPIO set %d to High:\n", i);
			ret = PET_GPIO_TotalNumber(i, &gpio_pin);
			ret = PET_GPIO_ReadDirection(i, &gpio_direction);
			ret = PET_GPIO_Write(i, 0xff);
			if (ret != NOERROR)
				printf(" PET_GPIO_Write(%d) failed %d\n", i, ret);
			else
				printf(" PET_GPIO_Write group %d to 1\n", i);
#ifndef __linux__
		system ("pause");
#else
		printf("Press Enter key to continue...\n");  
		fgetc(stdin); 
#endif
			printf(" GPIO PINS     : 1 2 3 4 5 6 7 8\n");
			printf(" GPIO Direction: %c %c %c %c %c %c %c %c\n", 
				gpio_pin>0?((gpio_direction&0x01)==0?'O':'I'):'X',
				gpio_pin>1?((gpio_direction&0x02)==0?'O':'I'):'X',
				gpio_pin>2?((gpio_direction&0x04)==0?'O':'I'):'X',
				gpio_pin>3?((gpio_direction&0x08)==0?'O':'I'):'X',
				gpio_pin>4?((gpio_direction&0x10)==0?'O':'I'):'X',
				gpio_pin>5?((gpio_direction&0x20)==0?'O':'I'):'X',
				gpio_pin>6?((gpio_direction&0x40)==0?'O':'I'):'X',
				gpio_pin>7?((gpio_direction&0x80)==0?'O':'I'):'X');
			ret = PET_GPIO_Read(i, &gpio_value);
			printf(" GPIO Data     : %c %c %c %c %c %c %c %c\n", 
				gpio_pin>0?((gpio_value&0x01)==0?'0':'1'):'X',
				gpio_pin>1?((gpio_value&0x02)==0?'0':'1'):'X',
				gpio_pin>2?((gpio_value&0x04)==0?'0':'1'):'X',
				gpio_pin>3?((gpio_value&0x08)==0?'0':'1'):'X',
				gpio_pin>4?((gpio_value&0x10)==0?'0':'1'):'X',
				gpio_pin>5?((gpio_value&0x20)==0?'0':'1'):'X',
				gpio_pin>6?((gpio_value&0x40)==0?'0':'1'):'X',
				gpio_pin>7?((gpio_value&0x80)==0?'0':'1'):'X');
		}
		for(i=j;i<=gpio_set;i++){
			ret = PET_GPIO_TotalNumber(i, &gpio_pin);
			ret = PET_GPIO_ReadDirection(i, &gpio_direction);		
			printf("Write GPIO set %d to Low:\n", i);
			ret = PET_GPIO_Write(i, 0);
			if (ret != NOERROR)
				printf(" PET_GPIO_Write(%d) failed %d\n", i, ret);
			else
				printf(" PET_GPIO_Write group %d to 0\n", i);
#ifndef __linux__
    system ("pause");
#else
    printf("Press Enter key to continue...\n");  
    fgetc(stdin); 
#endif
			printf(" GPIO PINS     : 1 2 3 4 5 6 7 8\n");
			ret = PET_GPIO_Read(i, &gpio_value);
			printf(" GPIO Data     : %c %c %c %c %c %c %c %c\n", 
				gpio_pin>0?((gpio_value&0x01)==0?'0':'1'):'X',
				gpio_pin>1?((gpio_value&0x02)==0?'0':'1'):'X',
				gpio_pin>2?((gpio_value&0x04)==0?'0':'1'):'X',
				gpio_pin>3?((gpio_value&0x08)==0?'0':'1'):'X',
				gpio_pin>4?((gpio_value&0x10)==0?'0':'1'):'X',
				gpio_pin>5?((gpio_value&0x20)==0?'0':'1'):'X',
				gpio_pin>6?((gpio_value&0x40)==0?'0':'1'):'X',
				gpio_pin>7?((gpio_value&0x80)==0?'0':'1'):'X');
		}
	}
	break;
#endif
#ifdef GPIO_READ
case GPIO_READ:
	printf("GPIO read test start:\n");
	ret = PET_GPIO_TotalSet(&gpio_set);
	if(ret == 0)
		printf(" Number of GPIO Groups: %d\n", gpio_set);
	else
		printf(" Number of GPIO Groups: Not Support\n");
	for(i=1;i<=gpio_set;i++){
		printf("Set %d GPIO info:\n", i);
		ret = PET_GPIO_TotalNumber(i, &gpio_pin);
		if(ret == 0)
			printf(" Number of GPIO Pins in the group: %d\n", gpio_pin);
		else
			printf(" Number of GPIO Pins: Not Support\n");
		ret = PET_GPIO_ReadDirection(i, &gpio_direction);
		if(ret == 0)
			printf(" GPIO Direction: %c %c %c %c %c %c %c %c\n", 
			gpio_pin>0?((gpio_direction&0x01)==0?'O':'I'):'X',
			gpio_pin>1?((gpio_direction&0x02)==0?'O':'I'):'X',
			gpio_pin>2?((gpio_direction&0x04)==0?'O':'I'):'X',
			gpio_pin>3?((gpio_direction&0x08)==0?'O':'I'):'X',
			gpio_pin>4?((gpio_direction&0x10)==0?'O':'I'):'X',
			gpio_pin>5?((gpio_direction&0x20)==0?'O':'I'):'X',
			gpio_pin>6?((gpio_direction&0x40)==0?'O':'I'):'X',
			gpio_pin>7?((gpio_direction&0x80)==0?'O':'I'):'X');
		else
			printf(" GPIO Direction: Not Support\n");
//		ret = PET_GPIO_ReadPinDirection (int gpio_set, int pin_num, unsigned char *io_direction);
		ret = PET_GPIO_Read(i, &gpio_value);
		if(ret == 0)
			printf(" GPIO Data     : %c %c %c %c %c %c %c %c\n", 
			gpio_pin>0?((gpio_value&0x01)==0?'0':'1'):'X',
			gpio_pin>1?((gpio_value&0x02)==0?'0':'1'):'X',
			gpio_pin>2?((gpio_value&0x04)==0?'0':'1'):'X',
			gpio_pin>3?((gpio_value&0x08)==0?'0':'1'):'X',
			gpio_pin>4?((gpio_value&0x10)==0?'0':'1'):'X',
			gpio_pin>5?((gpio_value&0x20)==0?'0':'1'):'X',
			gpio_pin>6?((gpio_value&0x40)==0?'0':'1'):'X',
			gpio_pin>7?((gpio_value&0x80)==0?'0':'1'):'X');
		else
			printf(" GPIO Data     : Not Support\n");
//		ret = PET_GPIO_ReadPin (int gpio_set, int pin_num, unsigned char *value);
	}
break;
#endif
#ifdef TEST_GPIO_INPUT
case TEST_GPIO_INPUT:

	printf ("GPIO1 PIN 1~8 is set GPI (high) \n");
	printf ("Press put jumper to test... from PIN 1 ~ 8\n");
	printf ("Press PIN 8 put jumper to low will exit test.\n");

	PET_GPIO_SetDirection (1, 0xFF); 

	i=1;
	for (;;)
	{
		for (i = 1; i <=8; i++)
		{
			PET_GPIO_ReadPin (1, i, &gpio_value);
			if (gpio_value == 0)
			{
				if (i == 8)
					goto ENDGPIOTEST;
				else
				{
					printf("GPI1 PIN %d input pull low detect!\n", i);
				}
			}
		}
	}
ENDGPIOTEST:
	printf ("GPI1 test finish\n");

break;
#endif
#ifdef TEST_GPIO_INPUT2
case TEST_GPIO_INPUT2:

	printf ("GPIO2 PIN 1~8 is set GPI (high) \n");
	printf ("Press put jumper to test... from PIN 1 ~ 8\n");
	printf ("Press PIN 8 put jumper to low will exit test.\n");

	PET_GPIO_SetDirection (2, 0xFF); 

	for (;;)
	{
		for (i = 1; i <=8; i++)
		{
			PET_GPIO_ReadPin (2, i, &gpio_value);
			if (gpio_value == 0)
			{
				if (i == 8)
					goto ENDGPIOTEST2;
				else
				{
					printf("GPI2 PIN %d input pull low detect!\n", i);
				}
			}
		}
	}
ENDGPIOTEST2:
	printf ("GPI2 test finish\n");

break;
#endif
#ifdef SMBUS_EEPROM_TEST
case SMBUS_EEPROM_TEST:
	printf("Please input target smbus device address(8 bits):\n");
	if(scanf("%hhx", &slave_addr)!=1){
		printf("Invalid Input!");
		break;
	}
	printf ("\n==== Test PET_SMBus_Read_EEPROM ====\n");
	printf ("   00 01 02 03 04 05 06 07 08 09 0a 0b 0c 0d 0e 0f\n");

	for (i = 0, offset = 0; i <= 0xF; i++)
	{
		printf ("%02X ", (i << 4));
		for (j = 0; j <= 0x0F; j++)
		{
			error_code = PET_SMBus_ByteData (SM_READ, slave_addr, offset, &(value[j]));
			if (error_code != NOERROR)
			{
				printf ("SMbus Slave addr 0x%02X no device, error code %d\n", slave_addr, error_code);
				continue;
			}else if (error_code == NOT_SUPPORT){
				printf ("\nThe SMBus function no support.\n");
				break;
			}

			printf ("%02X ", value[j]);
			offset++;
		}
		printf ("\n");
	}
	printf ("\n");
break;
#endif
#ifdef SMBUS_TEST
case SMBUS_TEST:
	return smbus_test(argc, argv);
break;
#endif
#ifdef SMBUS_SCAN
case SMBUS_SCAN:
	slave_addr = 0x10;
	value[0] = 0x00;
	offset=0;

	for (i = 0; i <= 7; i++)
	{
		for (j = 0; j <= 0x0F; j++)
		{
			error_code = PET_SMBus_ByteData (SM_READ, slave_addr, offset, value);
			if (error_code == NOERROR)
				printf ("\nslave_addr %02X read %02X = %02X\n", slave_addr, offset, value[0]);
			else if (error_code == NOT_SUPPORT){
				printf ("The SMBus function no support.\n");
				break;
			}
			else
				printf("%x ", (i*16+j)*2);
			slave_addr+=2;
		}
		printf ("\n");
	}
	printf ("\n");
break;
#endif
#ifdef BLC_TEST
case BLC_TEST:
	if (argc == 3) {
		i = atoi(argv[2]);
		if (i != 1 && i != 0) {
			printf("Invalid Input!");
			break;
		}
	}else{
		printf("Change brightness up or down?[1:up/0:down]\n");
		if(scanf("%d", &i)!=1){
			printf("Invalid Input!");
			break;
		}
	}
	ret = PET_BLC_Change_Brightness (i); 
	if (ret != NOERROR) {
		printf(" PET_BLC_Change_Brightness(%d) failed %d\n", i, ret);
		break;
	}else
		printf("Set Brightness %s\n", i==1?"UP":"DOWN");
break;
#endif
#ifdef BEEP_TEST
case BEEP_TEST:

	printf ("Beep alarm......");
				  // freq, sec
	PET_HWM_SetBeep (1000, 5); 
	printf ("END.\n");

break;
#endif
#ifdef NOTE_TEST
case NOTE_TEST:

	PET_HWM_SetMetronome (80);
	
	printf ("Play a song......");
	PET_HWM_PlayNote (0, 5, 0, 1);
	PET_HWM_PlayNote (0, 3, 0, 1);
	PET_HWM_PlayNote (0, 3, 0, 2);
	PET_HWM_PlayNote (0, 4, 0, 1);
	PET_HWM_PlayNote (0, 2, 0, 1);
	PET_HWM_PlayNote (0, 2, 0, 2);

	PET_HWM_PlayNote (0, 1, 0, 1);
	PET_HWM_PlayNote (0, 2, 0, 1);
	PET_HWM_PlayNote (0, 3, 0, 1);
	PET_HWM_PlayNote (0, 4, 0, 1);
	PET_HWM_PlayNote (0, 5, 0, 1);
	PET_HWM_PlayNote (0, 5, 0, 1);
	PET_HWM_PlayNote (0, 5, 0, 2);

	PET_HWM_PlayNote (0, 5, 0, 1);
	PET_HWM_PlayNote (0, 3, 0, 1);
	PET_HWM_PlayNote (0, 3, 0, 2);
	PET_HWM_PlayNote (0, 4, 0, 1);
	PET_HWM_PlayNote (0, 2, 0, 1);
	PET_HWM_PlayNote (0, 2, 0, 2);

	PET_HWM_PlayNote (0, 1, 0, 1);
	PET_HWM_PlayNote (0, 3, 0, 1);
	PET_HWM_PlayNote (0, 5, 0, 1);
	PET_HWM_PlayNote (0, 5, 0, 1);
	PET_HWM_PlayNote (0, 3, 0, 4);

	PET_HWM_PlayNote (0, 2, 0, 1);
	PET_HWM_PlayNote (0, 2, 0, 1);
	PET_HWM_PlayNote (0, 2, 0, 1);
	PET_HWM_PlayNote (0, 2, 0, 1);
	PET_HWM_PlayNote (0, 2, 0, 1);
	PET_HWM_PlayNote (0, 3, 0, 1);
	PET_HWM_PlayNote (0, 4, 0, 2);

	PET_HWM_PlayNote (0, 3, 0, 1);
	PET_HWM_PlayNote (0, 3, 0, 1);
	PET_HWM_PlayNote (0, 3, 0, 1);
	PET_HWM_PlayNote (0, 3, 0, 1);
	PET_HWM_PlayNote (0, 3, 0, 1);
	PET_HWM_PlayNote (0, 4, 0, 1);
	PET_HWM_PlayNote (0, 5, 0, 2);

	PET_HWM_PlayNote (0, 5, 0, 1);
	PET_HWM_PlayNote (0, 3, 0, 1);
	PET_HWM_PlayNote (0, 3, 0, 2);
	PET_HWM_PlayNote (0, 4, 0, 1);
	PET_HWM_PlayNote (0, 2, 0, 1);
	PET_HWM_PlayNote (0, 2, 0, 2);

	PET_HWM_PlayNote (0, 1, 0, 1);
	PET_HWM_PlayNote (0, 3, 0, 1);
	PET_HWM_PlayNote (0, 5, 0, 1);
	PET_HWM_PlayNote (0, 5, 0, 1);
	PET_HWM_PlayNote (0, 1, 0, 4);
	
	printf ("finish!!\n");
	
break;
#endif
#ifdef EC_IIC_RWC
case EC_IIC_RWC:
	if(argv[2] != NULL && argv[2][0]=='w')
		testeciic(2, argv[1], 0);
	else if(argv[2] != NULL && argv[2][0]=='t'){
		for (i = 0; testeciic(2, argv[1], i % 256) != 0 || testeciic(3, argv[1], 0) != 0; i++) {
			printf("run %d times\n", i);
		}
	}else
		testeciic(1, argv[1], 0) ;
break;
#endif
#ifdef LED_ONOFF
case LED_ONOFF:
	if (argc != 4)
	{
		printf("Usage: %s %d <led idx> <on|off>\n", argv[0], LED_ONOFF);
		printf("\t<on|off>: 1=on, 0=off\n");
		error_code=INVALID_PARAMETER;
		break;
	}
	gpio_pin=atoi(argv[2]);
	gpio_set=atoi(argv[3]);
	if(gpio_pin < 0 || (gpio_set != 0 && gpio_set != 1)){
		error_code=INVALID_PARAMETER;
		break;
	}
	error_code=PET_LED_Set(gpio_pin, gpio_set);
	if (error_code != NOERROR)
	{
		printf ("Set LED %d %s Failed(%d)\n", gpio_pin, gpio_set==1?"on":"off", error_code);
		break;
	}else if (error_code == NOT_SUPPORT){
		printf ("\nSet LED function no support.\n");
		break;
	}

break;
#endif
#ifdef LED_READ
case LED_READ:
	for(i=0;i<LED_MAX;i++){
		error_code = PET_LED_Get(i,&gpio_pin);
		if(error_code == NOERROR)
			printf("LED %d is %s\n", i, gpio_pin==1?"on":"off");
		else
			printf("LED %d is err(%#x)\n", i, error_code);
	}
break;
#endif
#ifdef LAN_BYPASS_CFG
case LAN_BYPASS_CFG:
	if(argc <= 2)
	{
		printf("Bypass function configurations:\n");
		ret = PET_LANBYPASS_Mode_Get(0,PET_LANBYPASS_ONOFF, &(bypasscfgs[3]));
		if(ret == 0)
			printf(" %20s: %s\n", bypass_status[PET_LANBYPASS_ONOFF], bypasscfgs[3]==1?"on":"off");
		else
			printf("Get %s failed!(%d)\n", bypass_status[PET_LANBYPASS_ONOFF], ret);
		ret = PET_LANBYPASS_Mode_Get(0,PET_LANBYPASS_WDT_TIMER, &(bypasscfgs[3]));
		if(ret == 0)
			printf("  watchdog timeout: %d seconds\n", bypasscfgs[3]);
		else
			printf("Get %s failed!(%d)\n", bypass_status[PET_LANBYPASS_WDT_TIMER], ret);
		for(i=0;i<2;i++){
			printf(" Lan port set: %d\n", i);
			for(j=PET_LANBYPASS_POWERON;j<=PET_LANBYPASS_WDT_TIMEOUT;j++)
			{
				ret = PET_LANBYPASS_Mode_Get(i,j, &(bypasscfgs[3]));
				if(ret == 0){
					printf("\t%23s: %s\n", bypass_status[j], bypass_mode[bypasscfgs[3]]);
				}else
					printf("Get %s failed!(%d)\n",  bypass_status[j], ret);
			}
		}
		printf("\n");
		error_code=NOERROR;
		break;
	}
	else if (argc != 5 && argc != 6)
	{
		printOCPUsage(argv[0]);
		error_code=INVALID_PARAMETER;
		if(argc != 2)
			printf("Argument number Incorrect!\n");
		break;
	}
	bypasscfgs[0]=atoi(argv[2]); //0=set 1=get
	bypasscfgs[1]=atoi(argv[3]); //lan port set
	bypasscfgs[2]=atoi(argv[4]); //config index

	if(bypasscfgs[0]==0 && argc == 6)//set option
	{
		bypasscfgs[3]=atoi(argv[5]); //config option
		ret = PET_LANBYPASS_Mode_Set(bypasscfgs[1],bypasscfgs[2],bypasscfgs[3]);
		if(ret != 0)
			printf("Lan bypass %s set Failed!error code=%d\n", bypass_status[bypasscfgs[2]], ret);
		else
			printf("Lan bypass %s set Success!\n", bypass_status[bypasscfgs[2]]);
		break;
	}
	else if(bypasscfgs[0]==1 && argc == 5)
	{
		ret = PET_LANBYPASS_Mode_Get(bypasscfgs[1],bypasscfgs[2], &(bypasscfgs[3]));
		if(ret == 0){
			printf("Lan port set: %d\n", bypasscfgs[1]);
			if(bypasscfgs[2] == PET_LANBYPASS_ONOFF)
				printf("%s: %s\n", bypass_status[bypasscfgs[2]], bypasscfgs[3]==1?"on":"off");
			else if(bypasscfgs[2] == PET_LANBYPASS_WDT_TIMER)
				printf("second mode timeout: %d seconds\n", bypasscfgs[3]);
			else{
				printf("%s: %s\n", bypass_status[bypasscfgs[2]], bypass_mode[bypasscfgs[3]]);
			}
		}else
			printf("PET_LANBYPASS_Mode_Get failed!(%d)\n", ret);
		return ret;
	}
	else
	{
		printOCPUsage(argv[0]);
		printf("Argument number Incorrect!\n");
		error_code=INVALID_PARAMETER;
		break;
	}

break;
#endif
#ifdef LAN_BYPASS_WDT_TEST
case LAN_BYPASS_WDT_TEST:
	printf ("\n==== Test LAN Bypass WDT Function ====\n");
	// wdt type: 0 is second mode, 1 is minute mode
	error_code = PET_LANBYPASS_Mode_Get (0, PET_LANBYPASS_WDT_TIMER, &bypasscfgs[0]);
	if (error_code == NOERROR)
		printf ("LAN Bypass WDT  timeout:%d seconds\n", bypasscfgs[0]);
	else if (error_code == NOT_SUPPORT){
		printf ("The LAN Bypass WDT get config function no support.\n");
		break;
	}else{
		printf ("The LAN Bypass WDT get config error, error code %d\n", error_code);
		break;
	}
    error_code = PET_LANBYPASS_WDT_Trigger (0);
	if (error_code == NOERROR)
		printf ("LAN Bypass WDT Trigger NOW !!\n");
	else if (error_code == NOT_SUPPORT){
		printf ("The LAN Bypass WDT trigger function no support.\n");
		break;
	}
	else{
		printf ("The LAN Bypass WDT trigger error, error code %d\n", error_code);
		break;
	}

	printf ("If you want to test LAN Bypass WDT timeout function, Please press Ctrl+C to force wdt_trigger stop before count end.\n");
	for(i=0,j=bypasscfgs[0];i<2*bypasscfgs[0];i++,j--)
	{
		if(i%(bypasscfgs[0]-2)==0){
			error_code = PET_LANBYPASS_WDT_Trigger(0);
			if(error_code == 0)
				printf ("LAN Bypass WDT Triggered\n");
			else{
				printf ("LAN Bypass WDT Trigger error!(%#x)\n", error_code);
				break;
			}
			j=bypasscfgs[0];
		}
		printf ("Reset counter ......%d\n", j);
		Sleep (1000);
	}
case LAN_BYPASS_WDT_DISABLE:		
		PET_LANBYPASS_WDT_Disable(0);
		printf("LAN Bypass WDT is disabled!\n");
break;
#endif
#ifdef BTN_TEST
case BTN_TEST:
	printf ("\n==== Test Button Status Function ====\n");
	error_code = PET_Button_Get (0, &i);
	if (error_code == NOERROR){
    	printf ("The Button is %s\n", i==1?"pressed":"unpressed");
		while(i == 1)
		{
			Sleep (1000);
			error_code = PET_Button_Get (0, &i);
			if(i==1)
				printf("Please unpress the button to start the test!\n");
		}
		printf("Please press the button to end test!\n");
		i=0;
		while(i == 0)
		{
			error_code = PET_Button_Get (0, &i);
			Sleep (500);
		}
		printf("The Button is pressed!\n");

	}else if (error_code == NOT_SUPPORT)
		printf ("The Button function no support.\n");
	else
		printf ("Get Button status error: %s(%d)\n", errorMsg[error_code], error_code);

break;
#endif
	default:
	 error_code = -1;
}

	PET_API_Uninit ();
#ifndef __linux__
    system ("pause");
#endif
    return error_code;
}

