﻿#ifndef	__PORTWELL_USETYPE__
#define	__PORTWELL_USETYPE__


// Return value definition
#define		NOERROR	                        0
#define		UNKNOWN_ERROR	                1
#define		DRIVER_NOT_FOUND	            2
#define		DRIVER_NOT_LOADED	            3
#define		DRIVER_NOT_LOADED_ON_NETWORK	4
#define		NOSUPPORTED_PLATFORM	        5
#define		INITIAL_ERROR					6
#define		INVALID_PARAMETER				7
#define		READ_ERROR						8
#define		WRITE_ERROR						9
#define		NOT_SUPPORT						10
#define		UNAVAILAVLE_SLEEP_TIME			11
#define		CANNOT_SET_IO_PERMISSION	    12
#define		CANNOT_SET_BACK_IO_PERMISSION	13
#define		NOT_READY						14
#define		UNAVAILABLE_SOUND				15
#define		DMI_GETMISS						16
#define		DEVICE_NOT_FOUND	            17

//API releated value
#define PET_FANMODE_MANUAL   0
#define PET_FANMODE_THERMAL  1
#define PET_FANMODE_SPEED    3
#define PET_FANMODE_SMART_III 5
#define PET_FANMODE_SMART_IV 7

#define PET_LANBYPASS_NORMAL_MODE 0
#define PET_LANBYPASS_OPEN_MODE   1
#define PET_LANBYPASS_BYPASS_MODE 3
typedef enum {
PET_LANBYPASS_ONOFF=0,
PET_LANBYPASS_POWERON=1,
PET_LANBYPASS_POWEROFF=2,
PET_LANBYPASS_NEXTBOOT=3,
PET_LANBYPASS_WDT_RUNNING=4,
PET_LANBYPASS_WDT_TIMEOUT=5,
PET_LANBYPASS_WDT_TIMER=6,
PET_LANBYPASS_MODE_MAX
}BYPASS_MODE_INDEX;
//Flags for get EC information
typedef enum 
{
    EC_VER,
	EC_BOARD_POSITION=0x10,
	SEC_EC_VER=0x80
} ECINFO_FLAG;

//Temperature sensor read value define
typedef enum 
{
	TSENSOR_SYS1=0,
	TSENSOR_SYS2,
	TSENSOR_SYS3,
	TSENSOR_SYS4,
	TSENSOR_PSU1,
	TSENSOR_PSU2,
	TSENSOR_DDR1,
	TSES_IDX_MAX,
#define PSU_TSENSOR1 0x140
#define PSU_TSENSOR2 0x141
} TEMPERATURE_SENSOR;

//Voltage read value define
typedef enum 
{
    VOL_VCORE, 
	VOL_VCCDDR,
	VOL_3P3V,
	VOL_VCC,
	VOL_12V,
	VOL_24V,
	VOL_VBAT,
	VOL_VTT,
	VOL_CCM,
	VOL_3VSB,
	VOL_AVSB,
	PSU_VIN,
	PSU_VOUT,
	VOL_12V2,
	VOL_IDX_MAX,
#define SEC_PSU_VIN 0x140
#define SEC_PSU_VOUT 0x141
} VOLTAGE_TYPE;

//Current read value define
typedef enum 
{
	CUR_PSU1,
	CUR_PSU2,
	CUR_IDX_MAX
} CURRENT_TYPE;

//Fan value define
typedef enum  
{
    CPUFAN,
    SYSFAN,
    AUXFAN,
	SYSFAN2,
    AUXFAN2,
	SYSFAN3,
    AUXFAN3,
	PSU_FAN1,
	PSU_FAN2,
	SYSFAN4,
    AUXFAN4,
	SYSFAN5,
    AUXFAN5,
	FAN_IDX_MAX,
#define SEC_PSU_FAN1 0x140
#define SEC_PSU_FAN2 0x141	
} FANTYPE;

typedef enum
{
	SECOND_MODE = 0,
	MINUTE_MODE
} WDT_TYPE;

typedef enum
{
	GPIO_OUTPUT,
	GPIO_INPUT,
} GPIO_TYPE;

typedef enum
{
	GPIO_LOW,
	GPIO_HIGH
} GPIO_RW;

typedef enum
{
    SM_WRITE,
    SM_READ,
} SMBUS_TYPE;


typedef enum
{
    BYTE_ADDR,
    WORD_ADDR,
} EC_IIC_ADDR_MODE;

typedef enum
{
    BYTE_DATA,
    WORD_DATA,
	LONG_DATA,

} EC_IIC_DATA_MODE;

typedef enum
{
   F400K,
   F100K,
   F50K,

} EC_FREQUENCY;

typedef enum 
{
	RSSI1_LED1=0, //EGPIO135
	RSSI1_LED2, //EGPIO136
	RSSI1_LED3, //EGPIO137
	RSSI1_LED4, //EGPIO138
	RSSI2_LED1, //EGPIO140
	RSSI2_LED2, //EGPIO141
	RSSI2_LED3, //EGPIO142
	RSSI2_LED4, //EGPIO143
	LTE_LED1,  //EGPIO145
	LTE_LED2,  //EGPIO146
	WIFI_LED1, //EGPIO147
	WIFI_LED2, //EGPIO148
	LED_MAX
} ANSB7A44E_LED;

typedef struct 
{
    int tjMax;
	int maxFrequency;
	char vendorName[13];
	int steppingId;
	int familyId;
	int modeId;
	int typeId;

	char CacheL1[150];
	char CacheL2[150];
	char CacheL3[150];

	char cacheTlbInfo[15][150];
	int cacheTlbInfoLength;
	char features[64][150];
	int featuresLength;

	double (*getVoltage)();
	int (*getCurrentFrequency)();
    int (*getCpuTemperature)();

}CpuInfo;

#endif