﻿#ifndef __PORTWELL_USERAPI__
#define	__PORTWELL_USERAPI__


#if defined(_WIN32_WCE)
	#ifdef PET_EXPORTS
		#define PETAPI __declspec(dllexport)
	#else
		#define PETAPI __declspec(dllimport)
	#endif
#elif defined(__linux__)
	#define	PETAPI
#elif defined(WIN32)
	#define	PETAPI	WINAPI
#else
	#define	PETAPI
#endif


#include "PET_Type.h" 

#define PET_VERSION_MAJOR 4
#define PET_VERSION_MINOR 7
#define PET_VERSION_BUILD 16
#define PET_VERSION_DATE "20240626"
#ifdef __cplusplus
extern "C"
{
#endif

#define PET_GPIO_INPUT_MODE 1
#define PET_GPIO_OUTPUT_MODE 0
#define SECOND_CHIP_MASK 0x100
#define BOARD_STR_LEN 80

// Local API Function 
int PETAPI PET_API_Init ();
int PETAPI PET_API_Uninit ();
int PETAPI PET_API_GetVersion (char *api_version);
int PETAPI PET_API_SetIOSleepTime (int msec);
int PETAPI PET_Board_GetBIOSVendor (char *bios_vendor);
int PETAPI PET_Board_GetBIOSVersion (char *bios_version);
int PETAPI PET_Board_GetECVersion (char *ec_version);
int PETAPI PET_Board_GetECInfo (int ec_flag, char *ec_data);
int PETAPI PET_Board_GetPlatformName (char *name);
int PETAPI PET_Board_GetSerialNumber(char *serial_number);
int PETAPI PET_Board_GetPlatformType(char *platform_type);

int PETAPI PET_GPIO_TotalSet (int *gpio_set_number);
int PETAPI PET_GPIO_TotalNumber (int gpio_set, int *available_pin_number);
int PETAPI PET_GPIO_SetDirection (int gpio_set, unsigned char io_direction);
int PETAPI PET_GPIO_SetPinDirection (int gpio_set, int pin_num, unsigned char io_direction);
int PETAPI PET_GPIO_ReadDirection (int gpio_set, unsigned char *io_direction);
int PETAPI PET_GPIO_ReadPinDirection (int gpio_set, int pin_num, unsigned char *io_direction);
int PETAPI PET_GPIO_Read (int gpio_set, unsigned char *value);
int PETAPI PET_GPIO_ReadPin (int gpio_set, int pin_num, unsigned char *value);
int PETAPI PET_GPIO_Write (int gpio_set, unsigned char value);
int PETAPI PET_GPIO_WritePin (int gpio_set, int pin_num, unsigned char value);

int PETAPI PET_WDT_Available ();
int PETAPI PET_WDT_GetRange (int type, unsigned char *minimum, unsigned char *maximum);
int PETAPI PET_WDT_SetConfig (int type, unsigned char timeout);
int PETAPI PET_WDT_GetConfig (int *type, unsigned char *timeout);
int PETAPI PET_WDT_Trigger ();
int PETAPI PET_WDT_Disable ();

int PETAPI PET_HWM_CPUNumber (int *cpu_num);
int PETAPI PET_HWM_Temperature (int sensor_name, double *temp_value);
int PETAPI PET_HWM_CPUTemperature (int cpu_num, double *cputemp_value);
int PETAPI PET_HWM_SysTemperature (double *systemp_value);
int PETAPI PET_HWM_Voltage (int vol_type, double *vol_value);
int PETAPI PET_HWM_Current (int cur_type, double *cur_value);
int PETAPI PET_HWM_GetFanSpeed (int fan_type, int *fan_value);
int PETAPI PET_HWM_SetFanSpeed (int fan_type, int fan_ratio);
int PETAPI PET_HWM_GetSmartfan(int fan_type, int* smart_mode, int temperature[], int ratio[], int* Temp_Tolerance);
int PETAPI PET_HWM_SetSmartfan(int fan_type, int smart_mode, int temperature[], int ratio[], int Temp_Tolerance);
int PETAPI PET_HWM_Smartfan_Enable(int fan_type);
int PETAPI PET_HWM_Smartfan_Disable(int fan_type);
int PETAPI PET_HWM_SetMetronome (int bpm);
int PETAPI PET_HWM_PlayNote (int level, int note, int up_key, double beats);
int PETAPI PET_HWM_SetBeep (double freq, int sec);

int PETAPI PET_SMBus_Available ();
int PETAPI PET_SMBus_ByteData (int r_w, unsigned char slave_addr, unsigned char offset, unsigned char *value);
int PETAPI PET_SMBus_WordData (int r_w, unsigned char slave_addr, unsigned char offset, unsigned int *value);
int PETAPI PET_SMBus_ProcessCall (unsigned char slave_addr, unsigned char offset, unsigned int *w_value, unsigned int *r_value);
int PETAPI PET_SMBus_Block (int r_w, unsigned char slave_addr, unsigned char offset, int byte_count, unsigned char *value);
int PETAPI PET_SMBus_Read_EEPROM (unsigned char slave, unsigned short address, int length, unsigned char *value);
int PETAPI PET_SMBus_Write_EEPROM (unsigned char slave, unsigned short address, int length, unsigned char *value);

//BLC test
int PETAPI PET_BLC_Change_Brightness (int ctrl);

int PETAPI PET_EC_IIC_Set_Frequency (EC_FREQUENCY fquency);
int PETAPI PET_EC_IIC_Word_Addr_Read (unsigned char slave_addr,unsigned int offset,unsigned char *value,int length);
int PETAPI PET_EC_IIC_Word_Addr_Write (unsigned char slave_addr,unsigned int offset,unsigned char *value,int length);
int PETAPI PET_EC_IIC_Byte_Addr_Read (unsigned char slave_addr,unsigned int offset,unsigned char *value,int length);
int PETAPI PET_EC_IIC_Byte_Addr_Write (unsigned char slave_addr,unsigned int offset,unsigned char *value,int length);
int PETAPI PET_EC_IIC_Quick_Read(unsigned char slave_addr, unsigned int offset, unsigned char *value);
int PETAPI PET_EC_IIC_Quick_Write(unsigned char slave_addr, unsigned int offset);
int PETAPI PET_EC_IIC_Receive_Byte(unsigned char slave_addr, unsigned char *value);
int PETAPI PET_EC_IIC_Send_Byte(unsigned char slave_addr, unsigned int offset);
int PETAPI PET_EC_SmartBattery (unsigned char address,unsigned char code, unsigned char *value);

int PETAPI PET_LANBYPASS_Mode_Set(int lanset, int modeidx, int cfg);
int PETAPI PET_LANBYPASS_Mode_Get(int lanset, int modeidx, int* cfg);
int PETAPI PET_LANBYPASS_WDT_Trigger(int lanset);
int PETAPI PET_LANBYPASS_WDT_Disable(int lanset);

int PETAPI PET_New_CPU_Obj(CpuInfo *obj);

int PETAPI PET_Read_IO_Byte (unsigned short addr, unsigned char *data);
int PETAPI PET_Read_IO_Word (unsigned short addr, unsigned short *data);
int PETAPI PET_Read_IO_DWord (unsigned short addr, unsigned long *data);
int PETAPI PET_Write_IO_Byte (unsigned short addr, unsigned char data);
int PETAPI PET_Write_IO_Word (unsigned short addr, unsigned short data);
int PETAPI PET_Write_IO_DWord (unsigned short addr, unsigned long data);
int PETAPI PET_Read_MSR (unsigned long index, unsigned long *eax, unsigned long *edx);

int PETAPI PET_EC_SMF_GetConfig(int *status, int *Temp_Start, int *Temp_Full, int *Temp_Tolerance);
int PETAPI PET_EC_SMF_Config(int Temp_Start, int Temp_Full, int Temp_Tolerance);
int PETAPI PET_EC_SMF_Enable();
int PETAPI PET_EC_SMF_Disable();

int PETAPI PET_LED_Set(int ledindex, int ledstatus);
int PETAPI PET_LED_Get(int ledindex, int* ledstatus);
int PETAPI PET_Button_Get(int btnindex, int* btnstatus);

int PETAPI PET_Get_Boot_Counter(unsigned int* boot_counter);
int PETAPI PET_Get_Platform_Version(unsigned int* platform_version);
int PETAPI PET_PCI_Register_Write (int bus, int devi, int func, unsigned char offset, unsigned char value);
int PETAPI PET_PCI_Register_Read (int bus, int devi, int func, unsigned char offset, unsigned char* value);
#ifdef __cplusplus
}
#endif
#endif
