#pragma once

#ifndef __PORTWELL_EAPI_TYPE__
#define	__PORTWELL_EAPI_TYPE__


#define MAXBUFFER 128

struct EApi_board_info
{
	char board_manufacturer[MAXBUFFER];
	char board_name[MAXBUFFER];
	char board_serial[MAXBUFFER];
	char board_platform_type[MAXBUFFER];
	char bios_revision[MAXBUFFER];
	char ec_version[MAXBUFFER];

	uint32_t eapi_spec_version;
	uint32_t board_pnpid;
	uint16_t platform_revision;
	uint32_t eapi_driver_version;
	uint32_t eapi_lib_version;
	uint32_t boot_counter;

};

struct EApi_HWMON_temp
{
	//cpu temperature using read msr
	//we don't have chipset temperature 
	unsigned char systemp_msb_cfg;
	unsigned char systemp_lsb_cfg;
};

struct EApi_HWMON_voltage
{
	unsigned char vcore_lsb_cfg;
	unsigned char vcore_msb_cfg;

	unsigned char v1p5_lsb_cfg;
	unsigned char v1p5_msb_cfg;

	unsigned char vcc3_lsb_cfg;
	unsigned char vcc3_msb_cfg;
	double        vcc3_ohm1;
	double        vcc3_ohm2;

	unsigned char vcc_lsb_cfg;
	unsigned char vcc_msb_cfg;
	double        vcc_ohm1;
	double        vcc_ohm2;

	unsigned char v12_lsb_cfg;
	unsigned char v12_msb_cfg;
	double        v12_ohm1;
	double        v12_ohm2;
};

struct EApi_HWMON_fan
{
	unsigned char cpu_fan_hb_cfg;
	unsigned char cpu_fan_lb_cfg;
	unsigned char sys_fan_hb_cfg;
	unsigned char sys_fan_lb_cfg;
};

struct EApi_IIC
{
	uint32_t max_block_length;
};

struct EApi_SMB
{
	// PCI Interface
	uint8_t DOMAIN_NAME;
	uint8_t LPC_BUS;
	uint8_t LPC_DEV;
	uint8_t LPC_FUNC;

	// PCI Configuration Register
	uint8_t SBA;           /* SMBus Base Address */
	uint8_t HCFG;          /* Host Configuration */

						   // PCI Config Control State
	uint8_t I2CEN;         /* I2C Enable */

						   // I/O Offset Register define
	uint8_t HSTS;          /* Host Status Register Address */
	uint8_t HCTL;          /* Host Control Register */
	uint8_t HCMD;          /* Host Command Register */
	uint8_t TSA;           /* Transmit Slave Address Register */
	uint8_t HD0;           /* Data 0 Register */
	uint8_t HD1;           /* Data 1 Register */
	uint8_t HBD;           /* Host Block Data */
	uint8_t AUXC;          /* Auxiliary Control */

						   // I/O Offset Register Control State
	uint8_t E32B;          /* Setting Block R/W mode */

						   // SMBus & IIC Select mode
	uint8_t BYTE;            // Setting byte mode
	uint8_t BYTE_MODE;       // Setting byte data mode
	uint8_t WORD_MODE;       // Setting word data mode
	uint8_t PROCESS_MODE;    // Setting process call mode
	uint8_t BLOCK_MODE;      // Setting block mode
	uint8_t PBLOCK_MODE;     // Setting process block mode (not use)
	uint8_t IIC_READ_MODE;   // Setting write read combine
	uint8_t IIC_BLOCK_MODE;

	// Receive data
	uint32_t  base_addr;       // Store SMbus base address
	uint32_t  smbus_doing;     // check smbus available
};

struct EApi_WDT
{
	unsigned char wdt_cfg;  /* wdt mode */
	unsigned char wdt_crm;  /* wdt minute */
	unsigned char wdt_crs;  /* wdt second */
	unsigned char doing;    /* wdt doing  */
	unsigned char timeout;  /* wdt timeout */
};

struct EApi_GPIO
{
	unsigned char gpio_dira;
	unsigned char gpio_data;
};

struct EApi_arch
{
	uint32_t pw_init;
	int EApi_board_info_sel;
	int EApi_BLE_func_sel;
	int EApi_storage_func_sel;
	int EApi_iic_func_sel;
	int EApi_smbus_func_sel;
	int EApi_wdt_func_sel;
	int EApi_gpio_func_sel;

	//struct EApi_board_info    board_info;
	//struct EApi_HWMON_temp    board_temperature;
	//struct EApi_HWMON_voltage board_voltage;
	//struct EApi_HWMON_fan     board_fan;
	//struct EApi_IIC           ec_iic;
	//struct EApi_SMB           smbus;
	struct EApi_WDT           wdt;
	//struct EApi_GPIO          gpio;
};

#endif
