#ifndef _PET_EAPI_H_
#define _PET_EAPI_H_

#if defined(_WIN32_WCE)
#ifdef PET_EXPORTS
#define PEAPI __declspec(dllexport)
#else
#define PEAPI __declspec(dllimport)
#endif
#elif defined(__linux__)
#define	PEAPI
#elif defined(WIN32)
#ifndef WINAPI
#define	WINAPI __stdcall
#endif
#define	PEAPI	WINAPI

#elif defined(__QNX__)
#define	PEAPI
#endif

#ifdef __cplusplus
extern "C" {
#endif

#include <stdint.h>

#ifndef PEAPI_UINT32_C
#  define PEAPI_UINT8_C(x)  ((uint8_t)(x))
#  define PEAPI_UINT16_C(x) ((uint16_t)(x))
#  define PEAPI_UINT32_C(x) ((uint32_t)(x))
#endif

	typedef uint32_t PEApiStatus_t;
	typedef uint32_t PEApiId_t;

	PEApiStatus_t PEAPI EApiLibInitialize(void);   /* Should be called before
													* calling any other API
													* function is called
													*/
	PEApiStatus_t PEAPI EApiLibUnInitialize(void); /* Should be called before
													* program exit
													*/

	PEApiStatus_t PEAPI EApiBoardGetStringA(
		PEApiId_t Id,                               /* _IN    Name Id */
		char *pBuffer,                              /* _OUT   Destination pBuffer */
		uint32_t *pBufLen                           /* _INOUT pBuffer Length */
		);
	PEApiStatus_t PEAPI EApiBoardGetValue(
		PEApiId_t Id,                                /* _IN    Value Id */
		uint32_t *pValue                             /* _OUT   Return Value */
		);

	PEApiStatus_t PEAPI EApiI2CGetBusCap(
		uint32_t Id,								 /* I2C Bus Id */
		uint32_t *pMaxBlkLen						 /* Max Block Length Supported on this interface*/
		);
	PEApiStatus_t PEAPI EApiI2CWriteReadRaw(
			PEApiId_t Id,							/*I2C Bus Id */
			uint8_t Addr,							/*Encoded 7Bit I2C* Device Address*/
			void *pWBuffer,							/*Write Data pBuffer */
			uint32_t WriteBCnt,						/* Number of Bytes to * write plus 1*/
			void *pRBuffer,							/*Read Data pBuffer */
			uint32_t RBufLen,						/*Data pBuffer Length */
			uint32_t ReadBCnt						/*Number of Bytes to* Read plus 1*/
		);
	PEApiStatus_t PEAPI EApiI2CReadTransfer(
			PEApiId_t Id,							/*I2C Bus Id */
			uint32_t Addr,							/*Encoded 7/10Bit I2C* Device Address*/
			uint32_t Cmd,							/*I2C Command/Offset */
			void *pBuffer,							/* Transfer Data pBuffer */
			uint32_t BufLen,						/* Data pBuffer Length */
			uint32_t ByteCnt						/*Byte Count to read */
		);


	PEApiStatus_t PEAPI EApiI2CWriteTransfer(
			PEApiId_t Id,							/* I2C Bus Id */
			uint32_t Addr ,							/* Encoded 7/10Bit I2C * Device Address */
			uint32_t Cmd,							/* I2C Command/Offset */
			void *pBuffer,							/* Transfer Data pBuffer */
			uint32_t ByteCnt						/*Byte Count to write */
		);
	PEApiStatus_t PEAPI EApiI2CProbeDevice(
			PEApiId_t Id, /* I2C Bus Id */
			uint32_t Addr/* Encoded 7/10Bit I2C * Device Address */
		);

	PEApiStatus_t PEAPI EApiI2CReadByte(
		uint8_t   Addr,                              /* Encode 7Bit I2C Device Address */
		uint32_t  cmd,                               /* I2C Command/Offset */
		uint8_t  *pBuffer                            /* Transfer Data pBuffer */
		);
	PEApiStatus_t PEAPI EApiI2CWriteByte(
		uint8_t   Addr,                              /* Encode 7Bit I2C Device Address */
		uint32_t  cmd,                               /* I2C Command/Offset */
		uint8_t  *pBuffer                            /* Transfer Data pBuffer */
		);


	PEApiStatus_t PEAPI EApiSMBusReadByte(
		uint8_t  Addr,                               /* Encoded 7Bit SMBus Device Address */
		uint8_t  cmd,                                /* SMBus Command/Offset */
		uint8_t *pBuffer                             /* Transfer Data pBuffer */
		);
	PEApiStatus_t PEAPI EApiSMBusWriteByte(
		uint8_t  Addr,                               /* Encoded 7Bit SMBus Device Address */
		uint8_t  cmd,                                /* SMBus Command/Offset */
		uint8_t  Buffer                              /* Transfer Data Buffer */
		);

	PEApiStatus_t PEAPI EApiWDogGetCap(
		uint32_t *pMaxDelay,                        /* _OUT   Maximum Supported Delay in milliseconds */
		uint32_t *pMaxEventTimeout,                 /* _OUT   Maximum Supported Event Timeout in milliseconds */
		uint32_t *pMaxResetTimeout                  /* _OUT   Maximum Supported Reset Timeout in milliseconds */
		);
	PEApiStatus_t PEAPI EApiWDogStart(
		uint32_t Delay,                             /* _IN    Delay in millseconds */
		uint32_t EventTimeout,                      /* _IN    Event Timeout in milliseconds */
		uint32_t ResetTimeout                       /* _IN    Reset Timeout in milliseconds */
		);
	PEApiStatus_t PEAPI EApiWDogTrigger(void);
	PEApiStatus_t PEAPI EApiWDogStop(void);

	PEApiStatus_t PEAPI EApiGPIOGetDirectionCaps(
		PEApiId_t Id,                               /* _IN    GPIO Id */
		uint32_t *pInputs,                          /* _OUT   Supported GPIO Input Bit Mask */
		uint32_t *pOutputs                          /* _OUT   Supported GPIO Output Bit Mask */
		);
	PEApiStatus_t PEAPI EApiGPIOGetDirection(
		PEApiId_t Id,                               /* _IN    GPIO Id */
		uint32_t Bitmask,                           /* _IN    Bit mask of Affected Bits */
		uint32_t *pDirection                        /* _OUT   Current Direction */
		);
	PEApiStatus_t PEAPI EApiGPIOSetDirection(
		PEApiId_t Id,                               /* _IN    GPIO Id */
		uint32_t Bitmask,                           /* _IN    Bit mask of Affected Bits */
		uint32_t Direction                          /* _IN    Direction */
		);
	PEApiStatus_t PEAPI EApiGPIOGetLevel(
		PEApiId_t Id,                               /* _IN    GPIO Id */
		uint32_t Bitmask,                           /* _IN    Bit mask of Affected Bits */
		uint32_t *pLevel                            /* _OUT   Current Level */
		);
	PEApiStatus_t PEAPI EApiGPIOSetLevel(
		PEApiId_t Id,                               /* _IN    GPIO Id */
		uint32_t Bitmask,                           /* _IN    Bit maak of Affected Bits */
		uint32_t Level                              /* _IN    Level */
		);

	PEApiStatus_t PEAPI EApiVgaGetBacklightEnable(
		PEApiId_t Id,								//__IN EApiId_t Id, /* Backlight Id */
		uint32_t *pEnable							//__OUT uint32_t *pEnable /* Backlight Enable */
	);
	PEApiStatus_t PEAPI EApiVgaSetBacklightEnable(
		PEApiId_t Id,								//__IN EApiId_t Id, /* Backlight Id */
		uint32_t Enable								//__IN uint32_t Enable /* Backlight Enable */
	);
	PEApiStatus_t PEAPI EApiVgaGetBacklightBrightness(
		PEApiId_t Id,								//__IN EApiId_t Id, /* Backlight Id */
		uint32_t *pBright							//__OUT uint32_t *pBright /* Backlight Brightness */
	);
	PEApiStatus_t PEAPI	EApiVgaSetBacklightBrightness(
		PEApiId_t Id,								//__IN EApiId_t Id, /* Backlight Id */
		uint32_t *pBright							//__IN uint32_t Bright /* Backlight Brightness */
	);
/*--------------------------------threre are not support as follow.--------------------------------------*/	
	

	
	PEApiStatus_t PEAPI	EApiStorageCap(
		PEApiId_t Id,								//__IN EApiId_t Id, /* Storage Area Id */
		uint32_t *pStorageSize,						//__OUT uint32_t *pStorageSize, /* Total */
		uint32_t *pBlockLength						//__OUT uint32_t *pBlockLength /* Write Block Length * & Alignment										 
		);	
	PEApiStatus_t PEAPI	EApiStorageAreaRead(
		PEApiId_t Id,								//__IN EApiId_t Id, /* Storage Area Id */
		uint32_t Offset,							//__IN uint32_t Offset, /* Byte Offset */
		void *pBuffer,								//__OUT void *pBuffer, /* Pointer to Data pBuffer */
		uint32_t BufLen,							//__IN uint32_t BufLen, /* Data pBuffer Size in * bytes*/
		uint32_t ByteCnt							//__IN uint32_t ByteCnt /* Number of bytes to read */
		);	
	PEApiStatus_t PEAPI	EApiStorageAreaWrite(
		PEApiId_t Id,								//__IN EApiId_t Id, /* Storage Area Id */
		uint32_t Offset,							//__IN uint32_t Offset, /* Byte Offset */
		void *pBuffer,								//__IN void *pBuffer, /* Pointer to Data pBuffer */
		uint32_t ByteCnt							//__IN uint32_t ByteCnt /* Number of bytes to write */
		);

#ifdef __cplusplus
}
#endif


#endif /* PET_EAPI_H_ */